package com.ximai.mes.pro.service.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessTool;
import com.ximai.mes.pro.domain.vo.ProProductionMakeProcessToolVo;

/**
 * 打样申请工序工装夹具Service接口
 *
 * @author generator
 * @date 2024-01-27
 */
public interface IProProductionMakeProcessToolService
{
    /**
     * 查询打样申请工序工装夹具
     *
     * @param productionMakeProcessToolId 打样申请工序工装夹具主键
     * @return 打样申请工序工装夹具
     */
    public ProProductionMakeProcessTool selectProProductionMakeProcessToolByProductionMakeProcessToolId(Long productionMakeProcessToolId);

    /**
     * 查询打样申请工序工装夹具列表
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 打样申请工序工装夹具集合
     */
    public List<ProProductionMakeProcessTool> selectProProductionMakeProcessToolList(ProProductionMakeProcessTool proProductionMakeProcessTool);

    public List<ProProductionMakeProcessToolVo> selectProProductionMakeProcessToolVoList(ProProductionMakeProcessTool proProductionMakeProcessTool);

    /**
     * 新增打样申请工序工装夹具
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    public int insertProProductionMakeProcessTool(ProProductionMakeProcessTool proProductionMakeProcessTool);

    /**
     * 修改打样申请工序工装夹具
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    public int updateProProductionMakeProcessTool(ProProductionMakeProcessTool proProductionMakeProcessTool);

    /**
     * 批量删除打样申请工序工装夹具
     *
     * @param productionMakeProcessToolIds 需要删除的打样申请工序工装夹具主键集合
     * @return 结果
     */
    public int deleteProProductionMakeProcessToolByProductionMakeProcessToolIds(Long[] productionMakeProcessToolIds);

    /**
     * 删除打样申请工序工装夹具信息
     *
     * @param productionMakeProcessToolId 打样申请工序工装夹具主键
     * @return 结果
     */
    public int deleteProProductionMakeProcessToolByProductionMakeProcessToolId(Long productionMakeProcessToolId);
}
