package com.ximai.mes.pro.service.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ProWorkOrderSoSizeItemDynamic;

import java.util.List;
import java.util.Map;

/**
 * 生产工单尺码Service接口
 *
 * @author zht
 * @date 2024-02-29
 */
public interface IProWorkOrderSoSizeItemService {
    /**
     * 查询生产工单尺码
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 生产工单尺码
     */
    ProWorkOrderSoSizeItem selectProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId);

    /**
     * 查询生产工单尺码列表
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 生产工单尺码集合
     */
    List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItemList(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 查询生产工单尺码列表
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 生产工单尺码集合
     */
    ProWorkOrderSoSizeItemDynamic selectProWorkOrderSoSizeItemListDynamic(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);


    /**
     * 查询生产工单尺码数据
     *
     * @param query 生产工单尺码
     * @return 生产工单尺码集合
     */
    List<ProWorkOrderSoSizeItem> selectProWorkOrderSoSizeItem(QueryWrapper<ProWorkOrderSoSizeItem> query);

    /**
     * 查询生产工单尺码列表
     *
     * @param query 生产工单尺码
     * @return 生产工单尺码集合
     */
    List<Map<String, Object>> selectProWorkOrderSoSizeItemListMap(QueryWrapper<ProWorkOrderSoSizeItem> query);

    /**
     * 新增生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    int insertProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 修改生产工单尺码
     *
     * @param proWorkOrderSoSizeItem 生产工单尺码
     * @return 结果
     */
    int updateProWorkOrderSoSizeItem(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem);

    /**
     * 批量删除生产工单尺码
     *
     * @param workorderSoSizeItemIds 需要删除的生产工单尺码主键集合
     * @return 结果
     */
    int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemIds(Long[] workorderSoSizeItemIds);

    /**
     * 删除生产工单尺码信息
     *
     * @param workorderSoSizeItemId 生产工单尺码主键
     * @return 结果
     */
    int deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemId(Long workorderSoSizeItemId);

    void deleteByWorkorderCode(String workorderCode);
}
