package com.ximai.mes.pro.service.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.vo.ProProcessTaskVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 生产工单工序Service接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface IProWorkOrderProcessService {
    /**
     * 查询生产工单工序
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 生产工单工序
     */
    ProWorkOrderProcessVo selectProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId);

    /**
     * 查询生产工单工序列表
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 生产工单工序集合
     */
    List<ProWorkOrderProcessVo> selectProWorkOrderProcessList(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 查询生产工单工序列表
     *
     * @param query
     * @return 生产工单工序集合
     */
    List<ProWorkOrderProcess> selectListByQw(@Param("ew") QueryWrapper<ProWorkOrderProcess> query);

    /**
     * 新增生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    int insertProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 修改生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    int updateProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess);

    /**
     * 批量删除生产工单工序
     *
     * @param workorderProcessIds 需要删除的生产工单工序主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessByWorkorderProcessIds(Long[] workorderProcessIds);

    /**
     * 删除生产工单工序信息
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 结果
     */
    int deleteProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId);


    void deleteByWorkorderCode(String workorderCode);

    List<ProProcessTaskVo> selectprocessReportFormList(ProProcessTaskVo proProcessTaskVo);
}
