package com.ximai.mes.pro.service.impl.prototypeRequest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestProcessItemMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessItem;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessItemService;

/**
 * 打样申请工序物料Service业务层处理
 *
 * @author zht
 * @date 2024-01-18
 */
@Service
public class ProPrototypeRequestProcessItemServiceImpl implements IProPrototypeRequestProcessItemService
{
    @Autowired
    private ProPrototypeRequestProcessItemMapper proPrototypeRequestProcessItemMapper;

    /**
     * 查询打样申请工序物料
     *
     * @param prototypeRequestProcessItemId 打样申请工序物料主键
     * @return 打样申请工序物料
     */
    @Override
    public ProPrototypeRequestProcessItem selectProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(Long prototypeRequestProcessItemId)
    {
        return proPrototypeRequestProcessItemMapper.selectProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(prototypeRequestProcessItemId);
    }

    /**
     * 查询打样申请工序物料列表
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 打样申请工序物料
     */
    @Override
    public List<ProPrototypeRequestProcessItem> selectProPrototypeRequestProcessItemList(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        return proPrototypeRequestProcessItemMapper.selectProPrototypeRequestProcessItemList(proPrototypeRequestProcessItem);
    }

    /**
     * 新增打样申请工序物料
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequestProcessItem(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        return proPrototypeRequestProcessItemMapper.insertProPrototypeRequestProcessItem(proPrototypeRequestProcessItem);
    }

    /**
     * 修改打样申请工序物料
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequestProcessItem(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        return proPrototypeRequestProcessItemMapper.updateProPrototypeRequestProcessItem(proPrototypeRequestProcessItem);
    }

    /**
     * 批量删除打样申请工序物料
     *
     * @param prototypeRequestProcessItemIds 需要删除的打样申请工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemIds(Long[] prototypeRequestProcessItemIds)
    {
        return proPrototypeRequestProcessItemMapper.deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemIds(prototypeRequestProcessItemIds);
    }

    /**
     * 删除打样申请工序物料信息
     *
     * @param prototypeRequestProcessItemId 打样申请工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(Long prototypeRequestProcessItemId)
    {
        return proPrototypeRequestProcessItemMapper.deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(prototypeRequestProcessItemId);
    }
}
