package com.ximai.mes.pro.service.impl.prototypeRequest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestBomMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestBom;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestBomService;

/**
 * 打样申请BOMService业务层处理
 *
 * @author zht
 * @date 2024-01-18
 */
@Service
public class ProPrototypeRequestBomServiceImpl implements IProPrototypeRequestBomService
{
    @Autowired
    private ProPrototypeRequestBomMapper proPrototypeRequestBomMapper;

    /**
     * 查询打样申请BOM
     *
     * @param bomItemId 打样申请BOM主键
     * @return 打样申请BOM
     */
    @Override
    public ProPrototypeRequestBom selectProPrototypeRequestBomByBomItemId(Long bomItemId)
    {
        return proPrototypeRequestBomMapper.selectProPrototypeRequestBomByBomItemId(bomItemId);
    }

    /**
     * 查询打样申请BOM列表
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 打样申请BOM
     */
    @Override
    public List<ProPrototypeRequestBom> selectProPrototypeRequestBomList(ProPrototypeRequestBom proPrototypeRequestBom)
    {
        return proPrototypeRequestBomMapper.selectProPrototypeRequestBomList(proPrototypeRequestBom);
    }

    /**
     * 新增打样申请BOM
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequestBom(ProPrototypeRequestBom proPrototypeRequestBom)
    {
        return proPrototypeRequestBomMapper.insertProPrototypeRequestBom(proPrototypeRequestBom);
    }

    /**
     * 修改打样申请BOM
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequestBom(ProPrototypeRequestBom proPrototypeRequestBom)
    {
        return proPrototypeRequestBomMapper.updateProPrototypeRequestBom(proPrototypeRequestBom);
    }

    /**
     * 批量删除打样申请BOM
     *
     * @param bomItemIds 需要删除的打样申请BOM主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestBomByBomItemIds(Long[] bomItemIds)
    {
        return proPrototypeRequestBomMapper.deleteProPrototypeRequestBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除打样申请BOM信息
     *
     * @param bomItemId 打样申请BOM主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestBomByBomItemId(Long bomItemId)
    {
        return proPrototypeRequestBomMapper.deleteProPrototypeRequestBomByBomItemId(bomItemId);
    }
}
