package com.ximai.mes.pro.service.impl.prototypeMake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessToolVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeMake.ProPrototypeMakeProcessToolMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessTool;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessToolService;

/**
 * 打样制作工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProPrototypeMakeProcessToolServiceImpl implements IProPrototypeMakeProcessToolService
{
    @Autowired
    private ProPrototypeMakeProcessToolMapper proPrototypeMakeProcessToolMapper;
    @Autowired
    private MdItemMapper mdItemMapper;
    /**
     * 查询打样制作工序工装夹具
     *
     * @param prototypeMakeProcessToolId 打样制作工序工装夹具主键
     * @return 打样制作工序工装夹具
     */
    @Override
    public ProPrototypeMakeProcessTool selectProPrototypeMakeProcessToolByPrototypeMakeProcessToolId(Long prototypeMakeProcessToolId)
    {
        return proPrototypeMakeProcessToolMapper.selectProPrototypeMakeProcessToolByPrototypeMakeProcessToolId(prototypeMakeProcessToolId);
    }

    /**
     * 查询打样制作工序工装夹具列表
     *
     * @param proPrototypeMakeProcessTool 打样制作工序工装夹具
     * @return 打样制作工序工装夹具
     */
    @Override
    public List<ProPrototypeMakeProcessTool> selectProPrototypeMakeProcessToolList(ProPrototypeMakeProcessTool proPrototypeMakeProcessTool)
    {
        return proPrototypeMakeProcessToolMapper.selectProPrototypeMakeProcessToolList(proPrototypeMakeProcessTool);
    }

    @Override
    public List<ProPrototypeMakeProcessToolVo> selectProPrototypeMakeProcessToolVoList(ProPrototypeMakeProcessTool proPrototypeMakeProcessTool)
    {
        List<ProPrototypeMakeProcessToolVo> rst = new ArrayList<ProPrototypeMakeProcessToolVo>();
        ProPrototypeMakeProcessTool query = new ProPrototypeMakeProcessTool();
        query.setPrototypeMakeId(proPrototypeMakeProcessTool.getPrototypeMakeId());
        List<ProPrototypeMakeProcessTool> list = proPrototypeMakeProcessToolMapper.selectProPrototypeMakeProcessToolList(query);
        List<Long> ids = list.stream().map(s->s.getToolId()).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if(ids.size()>0){
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getItemId(), s->s)));
        }
        list.forEach(s->{
            ProPrototypeMakeProcessToolVo vo = new ProPrototypeMakeProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if(toolMap.containsKey(s.getToolId())){
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样制作工序工装夹具
     *
     * @param proPrototypeMakeProcessTool 打样制作工序工装夹具
     * @return 结果
     */
    @Override
    public int insertProPrototypeMakeProcessTool(ProPrototypeMakeProcessTool proPrototypeMakeProcessTool)
    {
        return proPrototypeMakeProcessToolMapper.insertProPrototypeMakeProcessTool(proPrototypeMakeProcessTool);
    }

    /**
     * 修改打样制作工序工装夹具
     *
     * @param proPrototypeMakeProcessTool 打样制作工序工装夹具
     * @return 结果
     */
    @Override
    public int updateProPrototypeMakeProcessTool(ProPrototypeMakeProcessTool proPrototypeMakeProcessTool)
    {
        return proPrototypeMakeProcessToolMapper.updateProPrototypeMakeProcessTool(proPrototypeMakeProcessTool);
    }

    /**
     * 批量删除打样制作工序工装夹具
     *
     * @param prototypeMakeProcessToolIds 需要删除的打样制作工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessToolByPrototypeMakeProcessToolIds(Long[] prototypeMakeProcessToolIds)
    {
        return proPrototypeMakeProcessToolMapper.deleteProPrototypeMakeProcessToolByPrototypeMakeProcessToolIds(prototypeMakeProcessToolIds);
    }

    /**
     * 删除打样制作工序工装夹具信息
     *
     * @param prototypeMakeProcessToolId 打样制作工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessToolByPrototypeMakeProcessToolId(Long prototypeMakeProcessToolId)
    {
        return proPrototypeMakeProcessToolMapper.deleteProPrototypeMakeProcessToolByPrototypeMakeProcessToolId(prototypeMakeProcessToolId);
    }
}
