package com.ximai.mes.pro.service.impl.productionSolution;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionProcessMapper;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 生产版本工序Service业务层处理
 *
 * @author zht
 * @date 2024-01-23
 */
@Service
public class ProProductionSolutionProcessServiceImpl implements IProProductionSolutionProcessService {
    @Autowired
    private ProProductionSolutionProcessMapper proProductionSolutionProcessMapper;

    /**
     * 查询生产版本工序
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 生产版本工序
     */
    @Override
    public ProProductionSolutionProcess selectProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId) {
        return proProductionSolutionProcessMapper.selectProProductionSolutionProcessByProductionSolutionProcessId(productionSolutionProcessId);
    }

    /**
     * 查询生产版本工序列表
     *
     * @param query 生产版本工序
     * @return 生产版本工序
     */
    @Override
    public List<ProProductionSolutionProcess> selectProProductionSolutionProcessList(QueryWrapper<ProProductionSolutionProcess> query) {
        return proProductionSolutionProcessMapper.selectProProductionSolutionProcessListByQw(query);
    }

    /**
     * 查询生产版本工序列表
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 生产版本工序
     */
    @Override
    public List<ProProductionSolutionProcessVo> selectProProductionSolutionProcessList(ProProductionSolutionProcess proProductionSolutionProcess) {
        return proProductionSolutionProcessMapper.selectProProductionSolutionProcessList(proProductionSolutionProcess);
    }

    /**
     * 新增生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess) {
        return proProductionSolutionProcessMapper.insertProProductionSolutionProcess(proProductionSolutionProcess);
    }

    /**
     * 修改生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess) {
        return proProductionSolutionProcessMapper.updateProProductionSolutionProcess(proProductionSolutionProcess);
    }

    /**
     * 批量删除生产版本工序
     *
     * @param productionSolutionProcessIds 需要删除的生产版本工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessByProductionSolutionProcessIds(Long[] productionSolutionProcessIds) {
        return proProductionSolutionProcessMapper.deleteProProductionSolutionProcessByProductionSolutionProcessIds(productionSolutionProcessIds);
    }

    /**
     * 删除生产版本工序信息
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId) {
        return proProductionSolutionProcessMapper.deleteProProductionSolutionProcessByProductionSolutionProcessId(productionSolutionProcessId);
    }
}
