package com.ximai.mes.pro.service.impl.productionMake;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeProcessMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcess;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessService;

/**
 * 量产制作工序Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@Service
public class ProProductionMakeProcessServiceImpl implements IProProductionMakeProcessService
{
    @Autowired
    private ProProductionMakeProcessMapper proProductionMakeProcessMapper;

    /**
     * 查询量产制作工序
     *
     * @param productionMakeProcessId 量产制作工序主键
     * @return 量产制作工序
     */
    @Override
    public ProProductionMakeProcess selectProProductionMakeProcessByProductionMakeProcessId(Long productionMakeProcessId)
    {
        return proProductionMakeProcessMapper.selectProProductionMakeProcessByProductionMakeProcessId(productionMakeProcessId);
    }

    /**
     * 查询量产制作工序列表
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 量产制作工序
     */
    @Override
    public List<ProProductionMakeProcess> selectProProductionMakeProcessList(ProProductionMakeProcess proProductionMakeProcess)
    {
        return proProductionMakeProcessMapper.selectProProductionMakeProcessList(proProductionMakeProcess);
    }

    /**
     * 新增量产制作工序
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 结果
     */
    @Override
    public int insertProProductionMakeProcess(ProProductionMakeProcess proProductionMakeProcess)
    {
        return proProductionMakeProcessMapper.insertProProductionMakeProcess(proProductionMakeProcess);
    }

    /**
     * 修改量产制作工序
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 结果
     */
    @Override
    public int updateProProductionMakeProcess(ProProductionMakeProcess proProductionMakeProcess)
    {
        return proProductionMakeProcessMapper.updateProProductionMakeProcess(proProductionMakeProcess);
    }

    /**
     * 批量删除量产制作工序
     *
     * @param productionMakeProcessIds 需要删除的量产制作工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessByProductionMakeProcessIds(Long[] productionMakeProcessIds)
    {
        return proProductionMakeProcessMapper.deleteProProductionMakeProcessByProductionMakeProcessIds(productionMakeProcessIds);
    }

    /**
     * 删除量产制作工序信息
     *
     * @param productionMakeProcessId 量产制作工序主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessByProductionMakeProcessId(Long productionMakeProcessId)
    {
        return proProductionMakeProcessMapper.deleteProProductionMakeProcessByProductionMakeProcessId(productionMakeProcessId);
    }
}
