package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderSoDirectiveMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderSoDirectiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * 生产工单指令Service业务层处理
 *
 * @author zht
 * @date 2024-02-29
 */
@Service
public class ProWorkOrderSoDirectiveServiceImpl implements IProWorkOrderSoDirectiveService {
    @Autowired
    private ProWorkOrderSoDirectiveMapper proWorkOrderSoDirectiveMapper;

    /**
     * 查询生产工单指令
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 生产工单指令
     */
    @Override
    public ProWorkOrderSoDirective selectProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId) {
        return proWorkOrderSoDirectiveMapper.selectProWorkOrderSoDirectiveByWorkorderSoDirectiveId(workorderSoDirectiveId);
    }

    /**
     * 查询生产工单指令列表
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 生产工单指令
     */
    @Override
    public List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(ProWorkOrderSoDirective proWorkOrderSoDirective) {
        return proWorkOrderSoDirectiveMapper.selectProWorkOrderSoDirectiveList(proWorkOrderSoDirective);
    }

    @Override
    public List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(Collection<? extends Serializable> idList) {
        return proWorkOrderSoDirectiveMapper.selectBatchIds(idList);
    }

    @Override
    public List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(QueryWrapper<ProWorkOrderSoDirective> qw) {
        return proWorkOrderSoDirectiveMapper.selectListByQw(qw);
    }

    /**
     * 新增生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    @Override
    public int insertProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective) {
        proWorkOrderSoDirective.createAction();
        return proWorkOrderSoDirectiveMapper.insertProWorkOrderSoDirective(proWorkOrderSoDirective);
    }

    /**
     * 修改生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    @Override
    public int updateProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective) {
        return proWorkOrderSoDirectiveMapper.updateProWorkOrderSoDirective(proWorkOrderSoDirective);
    }

    /**
     * 批量删除生产工单指令
     *
     * @param workorderSoDirectiveIds 需要删除的生产工单指令主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveIds(Long[] workorderSoDirectiveIds) {
        return proWorkOrderSoDirectiveMapper.deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveIds(workorderSoDirectiveIds);
    }

    /**
     * 删除生产工单指令信息
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId) {
        return proWorkOrderSoDirectiveMapper.deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveId(workorderSoDirectiveId);
    }

    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        QueryWrapper<ProWorkOrderSoDirective> proWorkOrderSoDirectiveQueryWrapper = new QueryWrapper<>();
        proWorkOrderSoDirectiveQueryWrapper.eq("workorder_code", workorderCode);
        proWorkOrderSoDirectiveMapper.deleteProWorkOrderSoDirective(proWorkOrderSoDirectiveQueryWrapper);
    }
}
