package com.ximai.mes.pro.service.impl.proWorkOrder;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessTool;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessToolMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessToolService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 工单工序质检项Service业务层处理
 *
 * @author zht
 * @date 2024-01-28
 */
@Service
public class ProWorkOrderProcessToolServiceImpl implements IProWorkOrderProcessToolService {
    @Resource
    private ProWorkOrderProcessToolMapper proWorkOrderProcessToolMapper;
    @Resource
    private ProWorkOrderProcessMapper proWorkOrderProcessMapper;

    /**
     * 查询工单工序质检项
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 工单工序质检项
     */
    @Override
    public ProWorkOrderProcessTool selectProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId) {
        return proWorkOrderProcessToolMapper.selectProWorkOrderProcessToolByWorkorderProcessToolId(workorderProcessToolId);
    }

    /**
     * 查询工单工序质检项列表
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 工单工序质检项
     */
    @Override
    public List<ProWorkOrderProcessTool> selectProWorkOrderProcessToolList(ProWorkOrderProcessTool proWorkOrderProcessTool) {
        return proWorkOrderProcessToolMapper.selectProWorkOrderProcessToolList(proWorkOrderProcessTool);
    }

    /**
     * 新增工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    @Override
    public int insertProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool) {
        proWorkOrderProcessTool.createAction();
        return proWorkOrderProcessToolMapper.insertProWorkOrderProcessTool(proWorkOrderProcessTool);
    }

    /**
     * 修改工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    @Override
    public int updateProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool) {
        proWorkOrderProcessTool.updateAction();
        return proWorkOrderProcessToolMapper.updateProWorkOrderProcessTool(proWorkOrderProcessTool);
    }

    /**
     * 批量删除工单工序质检项
     *
     * @param workorderProcessToolIds 需要删除的工单工序质检项主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessToolByWorkorderProcessToolIds(Long[] workorderProcessToolIds) {
        return proWorkOrderProcessToolMapper.deleteProWorkOrderProcessToolByWorkorderProcessToolIds(workorderProcessToolIds);
    }

    /**
     * 删除工单工序质检项信息
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId) {
        return proWorkOrderProcessToolMapper.deleteProWorkOrderProcessToolByWorkorderProcessToolId(workorderProcessToolId);
    }

    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        proWorkOrderProcessToolMapper.deleteByWorkorderCode(workorderCode);
    }

    @Override
    public boolean checkProcessToolIsExsit(Long taskWorkunitId) {
        List<ProWorkOrderProcessTool> processTools = proWorkOrderProcessToolMapper.selectRequiredToolByTaskWorkunitId(taskWorkunitId);
        List<ProWorkOrderProcess> proWorkOrderProcesses = proWorkOrderProcessMapper.selectProcessIsExistToolByTwId(taskWorkunitId);
        return CollectionUtil.isNotEmpty(processTools) || CollectionUtil.isNotEmpty(proWorkOrderProcesses);
    }

    @Override
    public Map<Long, Integer> selectRequiredToolForWorkunitTask(Long taskWorkunitId) {
        List<ProWorkOrderProcessTool> processTools = proWorkOrderProcessToolMapper.selectRequiredToolByTaskWorkunitId(taskWorkunitId);
        Map<Long, Optional<ProWorkOrderProcessTool>> map = processTools.stream().collect(Collectors.groupingBy(ProWorkOrderProcessTool::getToolId, Collectors.maxBy(Comparator.comparing(ProWorkOrderProcessTool::getQuantity))));

        return map.values().stream().filter(x -> x.get() != null).map(Optional::get).collect(Collectors.toMap(ProWorkOrderProcessTool::getToolId, x -> x.getQuantity().intValue()));
    }

}
