package com.ximai.mes.pro.service.impl.proWorkOrder;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessQcindexMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessQcindex;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessQcindexService;

/**
 * 工单工序工装Service业务层处理
 *
 * @author zht
 * @date 2024-01-28
 */
@Service
public class ProWorkOrderProcessQcindexServiceImpl implements IProWorkOrderProcessQcindexService
{
    @Autowired
    private ProWorkOrderProcessQcindexMapper proWorkOrderProcessQcindexMapper;

    /**
     * 查询工单工序工装
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 工单工序工装
     */
    @Override
    public ProWorkOrderProcessQcindex selectProWorkOrderProcessQcindexByWorkorderProcessQcindex(Long workorderProcessQcindex)
    {
        return proWorkOrderProcessQcindexMapper.selectProWorkOrderProcessQcindexById(workorderProcessQcindex);
    }

    /**
     * 查询工单工序工装列表
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 工单工序工装
     */
    @Override
    public List<ProWorkOrderProcessQcindex> selectProWorkOrderProcessQcindexList(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        return proWorkOrderProcessQcindexMapper.selectProWorkOrderProcessQcindexList(proWorkOrderProcessQcindex);
    }

    /**
     * 新增工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    @Override
    public int insertProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        return proWorkOrderProcessQcindexMapper.insertProWorkOrderProcessQcindex(proWorkOrderProcessQcindex);
    }

    /**
     * 修改工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    @Override
    public int updateProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        return proWorkOrderProcessQcindexMapper.updateProWorkOrderProcessQcindex(proWorkOrderProcessQcindex);
    }

    /**
     * 批量删除工单工序工装
     *
     * @param workorderProcessQcindexs 需要删除的工单工序工装主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessQcindexByWorkorderProcessQcindexs(Long[] workorderProcessQcindexs)
    {
        return proWorkOrderProcessQcindexMapper.deleteProWorkOrderProcessQcindexByIds(workorderProcessQcindexs);
    }

    /**
     * 删除工单工序工装信息
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessQcindexByWorkorderProcessQcindex(Long workorderProcessQcindex)
    {
        return proWorkOrderProcessQcindexMapper.deleteProWorkOrderProcessQcindexById(workorderProcessQcindex);
    }
}
