package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderChangeRecord;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderChangeRecordMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderChangeRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 工单变更记录Service业务层处理
 *
 * @author generator
 * @date 2024-04-18
 */
@Service
@Slf4j
public class ProWorkOrderChangeRecordServiceImpl implements IProWorkOrderChangeRecordService {
    @Autowired
    private ProWorkOrderChangeRecordMapper proWorkOrderChangeRecordMapper;


    /**
     * 查询工单变更记录
     *
     * @param id 工单变更记录主键
     * @return 工单变更记录
     */
    @Override
    public ProWorkOrderChangeRecord selectProWorkOrderChangeRecordById(Long id) {
        return proWorkOrderChangeRecordMapper.selectProWorkOrderChangeRecordById(id);
    }

    /**
     * 查询工单变更记录列表
     *
     * @param proWorkOrderChangeRecord 工单变更记录
     * @return 工单变更记录
     */
    @Override
    public List<ProWorkOrderChangeRecord> selectProWorkOrderChangeRecordList(ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        return proWorkOrderChangeRecordMapper.selectProWorkOrderChangeRecordList(proWorkOrderChangeRecord);
    }

    /**
     * 新增工单变更记录
     *
     * @param proWorkOrderChangeRecord 工单变更记录
     * @return 结果
     */
    @Override
    public int insertProWorkOrderChangeRecord(ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        proWorkOrderChangeRecord.createAction();
        return proWorkOrderChangeRecordMapper.insertProWorkOrderChangeRecord(proWorkOrderChangeRecord);
    }

    /**
     * 修改工单变更记录
     *
     * @param proWorkOrderChangeRecord 工单变更记录
     * @return 结果
     */
    @Override
    public int updateProWorkOrderChangeRecord(ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        proWorkOrderChangeRecord.updateAction();
        return proWorkOrderChangeRecordMapper.updateProWorkOrderChangeRecord(proWorkOrderChangeRecord);
    }

    /**
     * 批量删除工单变更记录
     *
     * @param ids 需要删除的工单变更记录主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderChangeRecordByIds(Long[] ids) {
        return proWorkOrderChangeRecordMapper.deleteProWorkOrderChangeRecordByIds(ids);
    }

    /**
     * 删除工单变更记录信息
     *
     * @param id 工单变更记录主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderChangeRecordById(Long id) {
        return proWorkOrderChangeRecordMapper.deleteProWorkOrderChangeRecordById(id);

    }
}