package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderBom;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderBomMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 生产工单BOMService业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Service
public class ProWorkOrderBomServiceImpl implements IProWorkOrderBomService {
    @Autowired
    private ProWorkOrderBomMapper proWorkOrderBomMapper;

    /**
     * 查询生产工单BOM
     *
     * @param bomItemId 生产工单BOM主键
     * @return 生产工单BOM
     */
    @Override
    public ProWorkOrderBom selectProWorkOrderBomByBomItemId(Long bomItemId) {
        return proWorkOrderBomMapper.selectProWorkOrderBomByBomItemId(bomItemId);
    }

    /**
     * 查询生产工单BOM列表
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 生产工单BOM
     */
    @Override
    public List<ProWorkOrderBom> selectProWorkOrderBomList(ProWorkOrderBom proWorkOrderBom) {
        return proWorkOrderBomMapper.selectProWorkOrderBomList(proWorkOrderBom);
    }

    /**
     * 新增生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    @Override
    public int insertProWorkOrderBom(ProWorkOrderBom proWorkOrderBom) {
        proWorkOrderBom.createAction();
        return proWorkOrderBomMapper.insertProWorkOrderBom(proWorkOrderBom);
    }

    /**
     * 修改生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    @Override
    public int updateProWorkOrderBom(ProWorkOrderBom proWorkOrderBom) {
        proWorkOrderBom.updateAction();
        return proWorkOrderBomMapper.updateProWorkOrderBom(proWorkOrderBom);
    }

    /**
     * 批量删除生产工单BOM
     *
     * @param bomItemIds 需要删除的生产工单BOM主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderBomByBomItemIds(Long[] bomItemIds) {
        return proWorkOrderBomMapper.deleteProWorkOrderBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除生产工单BOM信息
     *
     * @param bomItemId 生产工单BOM主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderBomByBomItemId(Long bomItemId) {
        return proWorkOrderBomMapper.deleteProWorkOrderBomByBomItemId(bomItemId);
    }

    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        QueryWrapper<ProWorkOrderBom> proWorkOrderBomQueryWrapper = new QueryWrapper<>();
        proWorkOrderBomQueryWrapper.eq("workorder_code", workorderCode);
        proWorkOrderBomMapper.deleteProWorkOrderBom(proWorkOrderBomQueryWrapper);
    }
}
