package com.ximai.mes.pro.service.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.mapper.ProProductQrcodeRuleMapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;

/**
 * 产品二维码规则Service业务层处理
 *
 * @author generator
 * @date 2024-08-31
 */
@Service
public class ProProductQrcodeRuleServiceImpl implements IProProductQrcodeRuleService
{
    @Autowired
    private ProProductQrcodeRuleMapper proProductQrcodeRuleMapper;

    /**
     * 查询产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 产品二维码规则
     */
    @Override
    public ProProductQrcodeRuleDto selectProProductQrcodeRuleDtoByRuleId(Long ruleId) {
        return proProductQrcodeRuleMapper.selectProProductQrcodeRuleByRuleId(ruleId);
    }

    /**
     * 查询产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 产品二维码规则
     */
    @Override
    public ProProductQrcodeRule selectProProductQrcodeRuleByRuleId(Long ruleId) {
        return proProductQrcodeRuleMapper.selectById(ruleId);
    }

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRule 产品二维码规则
     * @return 产品二维码规则
     */
    @Override
    public List<ProProductQrcodeRuleDto> selectProProductQrcodeRuleList(ProProductQrcodeRule proProductQrcodeRule) {
        return proProductQrcodeRuleMapper.selectProProductQrcodeRuleList(proProductQrcodeRule);
    }

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRuleQuery 产品二维码规则
     * @return 产品二维码规则
     */
    @Override
    public List<ProProductQrcodeRule> selectProProductQrcodeRuleList(QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery) {
        return proProductQrcodeRuleMapper.selectList(proProductQrcodeRuleQuery);
    }

    @Override
    public ProProductQrcodeRule selectProProductQrcodeRuleNewest(Long itemId, String clientCode) {
        QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery = new QueryWrapper<>();
        proProductQrcodeRuleQuery.eq("item_id", itemId);
        proProductQrcodeRuleQuery.eq(StringUtils.isNotEmpty(clientCode),"client_code", clientCode);
        proProductQrcodeRuleQuery.eq(StringUtils.isEmpty(clientCode),"ifnull(client_code,'')", "");
        proProductQrcodeRuleQuery.orderByDesc("create_time");
        List<ProProductQrcodeRule> list = this.selectProProductQrcodeRuleList(proProductQrcodeRuleQuery);
        if(list.size()>0){
            return list.get(0);
        }
        return null;
    }

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRuleQuery 产品二维码规则
     * @return 产品二维码规则
     */
    @Override
    public List<ProProductQrcodeRuleDto> selectProProductQrcodeRuleDtoList(QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery) {
        return proProductQrcodeRuleMapper.selectDtoListByQw(proProductQrcodeRuleQuery);
    }

    /**
     * 新增产品二维码规则
     *
     * @param proProductQrcodeRuleCreate 产品二维码规则
     * @return 结果
     */
    @Override
    public int insertProProductQrcodeRule(ProProductQrcodeRuleCreate proProductQrcodeRuleCreate) {

        ProProductQrcodeRule proProductQrcodeRule = new ProProductQrcodeRule();
        BeanUtil.copyProperties(proProductQrcodeRuleCreate, proProductQrcodeRule);
        proProductQrcodeRule.setCurrentSerial(1);
        proProductQrcodeRule.setCreateBy(SecurityUtils.getUsername());
        proProductQrcodeRule.setCreateTime(DateUtils.getNowDate());
        return proProductQrcodeRuleMapper.insertProProductQrcodeRule(proProductQrcodeRule);
    }

    /**
     * 修改产品二维码规则
     *
     * @param proProductQrcodeRuleUpdate 产品二维码规则
     * @return 结果
     */
    @Override
    public int updateProProductQrcodeRule(ProProductQrcodeRuleUpdate proProductQrcodeRuleUpdate) {
        ProProductQrcodeRule proProductQrcodeRule = new ProProductQrcodeRule();
        BeanUtil.copyProperties(proProductQrcodeRuleUpdate, proProductQrcodeRule);
        proProductQrcodeRule.setUpdateBy(SecurityUtils.getUsername());
        proProductQrcodeRule.setUpdateTime(DateUtils.getNowDate());
        return proProductQrcodeRuleMapper.updateProProductQrcodeRule(proProductQrcodeRule);
    }

    /**
     * 批量删除产品二维码规则
     *
     * @param ruleIds 需要删除的产品二维码规则主键
     * @return 结果
     */
    @Override
    public int deleteProProductQrcodeRuleByRuleIds(Long[] ruleIds) {
        return proProductQrcodeRuleMapper.deleteProProductQrcodeRuleByRuleIds(ruleIds);
    }

    /**
     * 删除产品二维码规则信息
     *
     * @param ruleId 产品二维码规则主键
     * @return 结果
     */
    @Override
    public int deleteProProductQrcodeRuleByRuleId(Long ruleId) {
        return proProductQrcodeRuleMapper.deleteProProductQrcodeRuleByRuleId(ruleId);
    }

    @Override
    public List<String> buildQrcode(ProProductQrcodeRule rule, Integer quantity) {
        //按天生成流水
        String currDateStr = DateUtil.format(LocalDateTime.now(), "yyMMdd");
        //判断是否切换日期
        if(!currDateStr.equals(rule.getLastDateFmt())){
            rule.setCurrentSerial(1);
        }
        if(rule.getCurrentSerial() != null && rule.getSerialLen() != null  && rule.getSerialLen() > 0){
            StringBuilder maxCurrentSerialString = new StringBuilder();
            for(int i=0; i < rule.getSerialLen(); i++){
                maxCurrentSerialString.append(9);
            }
            double maxCurrentSerial = new Double(maxCurrentSerialString.toString());
            Integer size = rule.getCurrentSerial() + quantity;
            ExceptionUtil.checkTrueThrowException(maxCurrentSerial < size, MessageUtils.message("rule.currentSerial.error",maxCurrentSerial - rule.getCurrentSerial(),quantity));
        }
        List<String> rst = new ArrayList<>();
        for(int i=0;i<quantity;i++){
            String temp = rule.buildQrcode();
            rst.add(temp);
            rule.setCurrentSerial(rule.getCurrentSerial()+1);
        }
        rule.setLastDateFmt(currDateStr);
        proProductQrcodeRuleMapper.updateById(rule);
        return rst;
    }
}
