package com.ximai.mes.pro.service;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProWorkstationMaterial;
import com.ximai.mes.pro.domain.vo.ProWorkstationMaterialVo;

/**
 * 工作中心发料申请Service接口
 * 
 * @author generator
 * @date 2024-07-26
 */
public interface IProWorkstationMaterialService 
{
    /**
     * 查询工作中心发料申请
     * 
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 工作中心发料申请
     */
    public ProWorkstationMaterialVo selectProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId);

    /**
     * 查询工作中心发料申请列表
     * 
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 工作中心发料申请集合
     */
    public List<ProWorkstationMaterialVo> selectProWorkstationMaterialList(ProWorkstationMaterialVo proWorkstationMaterial);


    /**
     * 新增工作中心发料申请
     * 
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    public int insertProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial);

    /**
     * 修改工作中心发料申请
     * 
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    public int updateProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial);

    /**
     * 批量删除工作中心发料申请
     * 
     * @param workstationMaterialIds 需要删除的工作中心发料申请主键集合
     * @return 结果
     */
    public int deleteProWorkstationMaterialByWorkstationMaterialIds(Long[] workstationMaterialIds);

    /**
     * 删除工作中心发料申请信息
     * 
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 结果
     */
    public int deleteProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId);

    List<ProWorkstationMaterialVo> selectProWorkstationMaterialLists(QueryWrapper<ProWorkstationMaterial> query);

    void updateWorkstationUpadteNum(List<ProWorkstationMaterial> proWorkstationMaterials);
}
