package com.ximai.mes.pro.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRule;

/**
 * 排产换型对照信息Service接口
 * 
 * @author generator
 * @date 2024-04-01
 */
public interface IProScheduleSetupRuleService 
{
    /**
     * 查询排产换型对照信息
     * 
     * @param ruleId 排产换型对照信息主键
     * @return 排产换型对照信息
     */
    public ProScheduleSetupRule selectProScheduleSetupRuleByRuleId(Long ruleId);

    /**
     * 查询排产换型对照信息列表
     * 
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 排产换型对照信息集合
     */
    public List<ProScheduleSetupRule> selectProScheduleSetupRuleList(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 新增排产换型对照信息
     * 
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    public int insertProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 修改排产换型对照信息
     * 
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    public int updateProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 批量删除排产换型对照信息
     * 
     * @param ruleIds 需要删除的排产换型对照信息主键集合
     * @return 结果
     */
    public int deleteProScheduleSetupRuleByRuleIds(Long[] ruleIds);

    /**
     * 删除排产换型对照信息信息
     * 
     * @param ruleId 排产换型对照信息主键
     * @return 结果
     */
    public int deleteProScheduleSetupRuleByRuleId(Long ruleId);

    /**
     * 查询规则配置
     * key=itemTypeName+processName
     * @param query
     * @return
     */
    public Map<String, Map<String, Integer>> selectProScheduleSetupRuleWithMap(QueryWrapper<ProScheduleSetupRule> query);
}
