package com.ximai.mes.pro.service;

import java.util.List;

import com.ximai.mes.pro.domain.ProProcess;
import com.ximai.mes.pro.domain.vo.ProProcessVo;

/**
 * 生产工序Service接口
 *
 * @date 2022-05-11
 */
public interface IProProcessService {
    /**
     * 查询生产工序
     *
     * @param processId 生产工序主键
     * @return 生产工序
     */
    ProProcess selectProProcessByProcessId(Long processId);

    /**
     * 查询生产工序列表
     *
     * @param proProcess 生产工序
     * @return 生产工序集合
     */
    List<ProProcess> selectProProcessList(ProProcess proProcess);

    String checkProcessCodeUnique(ProProcess proProcess);

    String checkProcessNameUnique(ProProcess proProcess);

    /**
     * 新增生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    int insertProProcess(ProProcess proProcess);

    /**
     * 修改生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    int updateProProcess(ProProcess proProcess);

    /**
     * 批量删除生产工序
     *
     * @param processIds 需要删除的生产工序主键集合
     * @return 结果
     */
    int deleteProProcessByProcessIds(Long[] processIds);

    /**
     * 删除生产工序信息
     *
     * @param processId 生产工序主键
     * @return 结果
     */
    int deleteProProcessByProcessId(Long processId);

    /**
     * ep传mes生产工序信息
     *
     * @param proProcessVo
     * @return 结果
     */
    int processCreate(ProProcessVo proProcessVo);
}
