package com.ximai.mes.pro.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProMaterialReturn;
import com.ximai.mes.pro.domain.vo.ProMaterialReturnVo;

import java.util.List;

/**
 * 退料申请Service接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface IProMaterialReturnService {


    /**
     * 查询退料申请
     *
     * @param materialReturnId 退料申请主键
     * @return 退料申请
     */
    ProMaterialReturn selectProMaterialReturnByMaterialReturnId(Long materialReturnId);

    /**
     * 查询退料申请列表
     *
     * @param proMaterialReturn 退料申请
     * @return 退料申请集合
     */
    List<ProMaterialReturn> selectProMaterialReturnList(ProMaterialReturn proMaterialReturn);

    /**
     * 新增退料申请
     *
     * @param proMaterialReturn 退料申请
     * @return 结果
     */
    int insertProMaterialReturn(ProMaterialReturn proMaterialReturn);

    void insertProMaterialReturns(List<ProMaterialReturn> appendList);

    /**
     * 修改退料申请
     *
     * @param proMaterialReturn 退料申请
     * @return 结果
     */
    int updateProMaterialReturn(ProMaterialReturn proMaterialReturn);

    /**
     * 批量删除退料申请
     *
     * @param materialReturnIds 需要删除的退料申请主键集合
     * @return 结果
     */
    int deleteProMaterialReturnByMaterialReturnIds(Long[] materialReturnIds);

    /**
     * 删除退料申请信息
     *
     * @param materialReturnId 退料申请主键
     * @return 结果
     */
    int deleteProMaterialReturnByMaterialReturnId(Long materialReturnId);

    List<ProMaterialReturnVo> selectProMaterialReturnLis(QueryWrapper<ProMaterialReturn> query);

    void insertPdaProMaterialReturn(List<ProMaterialReturn> proMaterialReturns);
}
