package com.ximai.mes.pro.schedule.impl.busi;

import com.ximai.mes.constant.WorkorderStatusEnum;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 排产完成工单状态数改
 */
@Component
public class WorkorderUpdate implements ScheduleBusiProcess{

    @Autowired
    private IProWorkorderService workorderService;
    @Override
    public void execute(List<JobResult> jobResults) {


        jobResults.forEach(job->{
            job.getWorkorderList().forEach(workorder->{
                //更新工单状态
                ProWorkorder proWorkorderUpdate = new ProWorkorder();
                proWorkorderUpdate.setStatus(WorkorderStatusEnum.ISSUED.getValue());
                proWorkorderUpdate.setArrangeCode(workorder.getArrangeCode());
                proWorkorderUpdate.setWorkorderId(workorder.getWorkorderId());
                proWorkorderUpdate.setQuantityScheduled(workorder.getQuantityScheduled().add(job.getQuantity()));
                proWorkorderUpdate.setBatchSerial(workorder.getBatchSerial()+1);
                workorderService.updateProWorkorder(proWorkorderUpdate);
            });
        });
    }

}
