package com.ximai.mes.pro.mapper.prototypeRequest;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcess;
import com.ximai.mes.pro.domain.vo.ProPrototypeRequestProcessVo;

/**
 * 打样申请工序Mapper接口
 *
 * @author zht
 * @date 2024-01-18
 */
public interface ProPrototypeRequestProcessMapper
{
    /**
     * 查询打样申请工序
     *
     * @param prototypeRequestProcessId 打样申请工序主键
     * @return 打样申请工序
     */
    public ProPrototypeRequestProcess selectProPrototypeRequestProcessByPrototypeRequestProcessId(Long prototypeRequestProcessId);

    /**
     * 查询打样申请工序列表
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 打样申请工序集合
     */
    public List<ProPrototypeRequestProcessVo> selectProPrototypeRequestProcessList(ProPrototypeRequestProcess proPrototypeRequestProcess);

    /**
     * 新增打样申请工序
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 结果
     */
    public int insertProPrototypeRequestProcess(ProPrototypeRequestProcess proPrototypeRequestProcess);

    /**
     * 修改打样申请工序
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 结果
     */
    public int updateProPrototypeRequestProcess(ProPrototypeRequestProcess proPrototypeRequestProcess);

    /**
     * 删除打样申请工序
     *
     * @param prototypeRequestProcessId 打样申请工序主键
     * @return 结果
     */
    public int deleteProPrototypeRequestProcessByPrototypeRequestProcessId(Long prototypeRequestProcessId);

    /**
     * 批量删除打样申请工序
     *
     * @param prototypeRequestProcessIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeRequestProcessByPrototypeRequestProcessIds(Long[] prototypeRequestProcessIds);

    /**
     * 根据打样申请单id查询所属所有工序
     * @param prototypeRequestId
     * @return
     */
    public List<ProPrototypeRequestProcessVo> selectProPrototypeRequestProcessByPrototypeRequestId(Long prototypeRequestId);

}
