package com.ximai.mes.pro.mapper.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcess;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessVo;

/**
 * 样品制作工序Mapper接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface ProPrototypeMakeProcessMapper
{
    /**
     * 查询样品制作工序
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 样品制作工序
     */
    public ProPrototypeMakeProcess selectProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId);

    /**
     * 查询样品制作工序列表
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 样品制作工序集合
     */
    public List<ProPrototypeMakeProcessVo> selectProPrototypeMakeProcessList(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 新增样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    public int insertProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 修改样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    public int updateProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 删除样品制作工序
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId);

    /**
     * 批量删除样品制作工序
     *
     * @param prototypeMakeProcessIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessIds(Long[] prototypeMakeProcessIds);

    List<ProPrototypeMakeProcessVo> selectProPrototypeMakeProcessByPrototypeMakeId(Long prototypeMakeId);
}
