package com.ximai.mes.pro.mapper.prototypeMake;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMake;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeVo;
import org.apache.ibatis.annotations.Param;

/**
 * 样品制作单Mapper接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface ProPrototypeMakeMapper extends BaseMapper<ProPrototypeMake>
{
    /**
     * 查询样品制作单
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 样品制作单
     */
    public ProPrototypeMakeVo selectProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId);

    /**
     * 查询样品制作单列表
     *
     * @param proPrototypeMake 样品制作单
     * @return 样品制作单集合
     */
    public List<ProPrototypeMakeVo> selectProPrototypeMakeList(ProPrototypeMake proPrototypeMake);

    /**
     * 新增样品制作单
     *
     * @param proPrototypeMake 样品制作单
     * @return 结果
     */
    public int insertProPrototypeMake(ProPrototypeMake proPrototypeMake);

    /**
     * 修改样品制作单
     *
     * @param proPrototypeMake 样品制作单
     * @return 结果
     */
    public int updateProPrototypeMake(ProPrototypeMake proPrototypeMake);

    /**
     * 删除样品制作单
     *
     * @param prototypeMakeId 样品制作单主键
     * @return 结果
     */
    public int deleteProPrototypeMakeByPrototypeMakeId(Long prototypeMakeId);

    /**
     * 批量删除样品制作单
     *
     * @param prototypeMakeIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeByPrototypeMakeIds(Long[] prototypeMakeIds);


    int updateProPrototypeMakeStatus(@Param("prototypeMakeId") Long prototypeMakeId,@Param("prototypeMakeStatus") int prototypeMakeStatus);

}
