package com.ximai.mes.pro.mapper.productionSolution;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;

import java.util.List;

/**
 * 生产版本工序物料Mapper接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface ProProductionSolutionProcessItemMapper {
    /**
     * 查询生产版本工序物料
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 生产版本工序物料
     */
    ProProductionSolutionProcessItem selectProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId);

    /**
     * 查询生产版本工序物料列表
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 生产版本工序物料集合
     */
    List<ProProductionSolutionProcessItem> selectProProductionSolutionProcessItemList(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 新增生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    int insertProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 修改生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    int updateProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem);

    /**
     * 删除生产版本工序物料
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 结果
     */
    int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId);

    /**
     * 批量删除生产版本工序物料
     *
     * @param productionSolutionProcessItemIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemIds(Long[] productionSolutionProcessItemIds);

    List<ProProductionSolutionProcessItem> selectProProductionSolutionProcessItemByProductionSolutionProcessId(Long productionSolutionProcessId);
}
