package com.ximai.mes.pro.mapper.productionSolution;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 生产版本工序图纸Mapper接口
 *
 * @author generator
 * @date 2024-08-29
 */
public interface ProProductionSolutionProcessDrawingMapper extends BaseMapper<ProProductionSolutionProcessDrawing>
{
    /**
     * 查询生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 生产版本工序图纸
     */
    public ProProductionSolutionProcessDrawingDto selectProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId);

    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 生产版本工序图纸集合
     */
    public List<ProProductionSolutionProcessDrawingDto> selectProProductionSolutionProcessDrawingList(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing);

    /**
     * 查询生产版本工序图纸列表
     *
     * @param query 生产版本工序图纸
     * @return 生产版本工序图纸集合
     */
    @Select(value="select t2.* from pro_production_solution t1 left join pro_production_solution_process_drawing t2 on t1.production_solution_id = t2.production_solution_id\n" +
            " ${ew.customSqlSegment}")
    public List<ProProductionSolutionProcessDrawing> selectProcessDrawingJoinSolution(@Param("ew") QueryWrapper<ProProductionSolutionProcessDrawing> query);

    /**
     * 新增生产版本工序图纸
     *
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 结果
     */
    public int insertProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing);

    /**
     * 修改生产版本工序图纸
     *
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 结果
     */
    public int updateProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing);

    /**
     * 删除生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 结果
     */
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId);

    /**
     * 批量删除生产版本工序图纸
     *
     * @param productionSolutionProcessFileIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileIds(Long[] productionSolutionProcessFileIds);

}
