package com.ximai.mes.pro.mapper.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessItem;

/**
 * 量产申请工序物料Mapper接口
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public interface ProProductionRequestProcessItemMapper
{
    /**
     * 查询量产申请工序物料
     *
     * @param productionRequestProcessItemId 量产申请工序物料主键
     * @return 量产申请工序物料
     */
    public ProProductionRequestProcessItem selectProProductionRequestProcessItemByProductionRequestProcessItemId(Long productionRequestProcessItemId);

    /**
     * 查询量产申请工序物料列表
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 量产申请工序物料集合
     */
    public List<ProProductionRequestProcessItem> selectProProductionRequestProcessItemList(ProProductionRequestProcessItem proProductionRequestProcessItem);

    /**
     * 新增量产申请工序物料
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 结果
     */
    public int insertProProductionRequestProcessItem(ProProductionRequestProcessItem proProductionRequestProcessItem);

    /**
     * 修改量产申请工序物料
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 结果
     */
    public int updateProProductionRequestProcessItem(ProProductionRequestProcessItem proProductionRequestProcessItem);

    /**
     * 删除量产申请工序物料
     *
     * @param productionRequestProcessItemId 量产申请工序物料主键
     * @return 结果
     */
    public int deleteProProductionRequestProcessItemByProductionRequestProcessItemId(Long productionRequestProcessItemId);

    /**
     * 删除量产申请工序物料
     *
     * @param productionRequestProcessId 量产申请工序主键
     * @return 结果
     */
    public int deleteProProductionRequestProcessItemByProductionRequestProcessId(Long productionRequestProcessId);

    /**
     * 批量删除量产申请工序物料
     *
     * @param productionRequestProcessItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionRequestProcessItemByProductionRequestProcessItemIds(Long[] productionRequestProcessItemIds);
    /**
     * 删除量产申请工序物料
     *
     * @param productionRequestId 量产申请工序主键
     * @return 结果
     */
    public int deleteProProductionRequestProcessItemByProductionRequestId(Long productionRequestId);
}
