package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产工单指令Mapper接口
 *
 * @author zht
 * @date 2024-02-29
 */
public interface ProWorkOrderSoDirectiveMapper extends BaseMapper<ProWorkOrderSoDirective> {
    /**
     * 查询生产工单指令
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 生产工单指令
     */
    ProWorkOrderSoDirective selectProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId);

    /**
     * 查询生产工单指令列表
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 生产工单指令集合
     */
    List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 新增生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    int insertProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 修改生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    int updateProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 删除生产工单指令
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 结果
     */
    int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId);

    /**
     * 批量删除生产工单指令
     *
     * @param workorderSoDirectiveIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveIds(Long[] workorderSoDirectiveIds);

    List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveByWorkorderId(Long workorderId);


    @Delete(value = "delete from pro_work_order_so_directive  ${ew.customSqlSegment}")
    void deleteProWorkOrderSoDirective(@Param("ew") QueryWrapper<ProWorkOrderSoDirective> queryWrapper);

    @Select(value = "select * from pro_work_order_so_directive  ${ew.customSqlSegment}")
    List<ProWorkOrderSoDirective> selectListByQw(@Param("ew") QueryWrapper<ProWorkOrderSoDirective> qw2);
}
