package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessTool;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工单工序质检项Mapper接口
 *
 * @author zht
 * @date 2024-01-28
 */
public interface ProWorkOrderProcessToolMapper extends BaseMapper<ProWorkOrderProcessTool> {
    /**
     * 查询工单工序质检项
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 工单工序质检项
     */
    ProWorkOrderProcessTool selectProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId);


    @Select("select  t1.* from pro_work_order_process_tool t1  left join pro_work_order_process t3 on t3.workorder_process_id = t1.workorder_process_id  left join pro_workorder t2 on t1.work_order_id = t2.workorder_id ${ew.customSqlSegment} ")
    List<ProWorkOrderProcessTool> selectListByQw(@Param("ew") QueryWrapper<ProWorkOrderProcessTool> query);

    /**
     * 查询工单工序质检项列表
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 工单工序质检项集合
     */
    List<ProWorkOrderProcessTool> selectProWorkOrderProcessToolList(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 新增工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    int insertProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 修改工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    int updateProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 删除工单工序质检项
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 结果
     */
    int deleteProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId);

    /**
     * 批量删除工单工序质检项
     *
     * @param workorderProcessToolIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessToolByWorkorderProcessToolIds(Long[] workorderProcessToolIds);

    List<ProWorkOrderProcessTool> selectProWorkOrderProcessToolByWorkorderProcessId(Long workorderProcessId);

    List<ProWorkOrderProcessTool> selectProWorkOrderProcessToolByWorkorderIds(Long[] workorderIds);


    @Delete("delete from pro_work_order_process_tool where workorder_process_id in (select workorder_process_id from pro_work_order_process where workorder_code=#{workorderCode}) ")
    void deleteByWorkorderCode(@Param("workorderCode") String workorderCode);


    @Select("select ptw.task_workunit_id, t1.task_id,t3.quantity quantity,t3.*\n" +
            "from pro_task t1\n" +
            "         inner join pro_task_workunit ptw on t1.task_id = ptw.task_id\n" +
            "         inner join (select arrange_code, workorder_code,workorder_process_tool_id,workorder_process_id,process_code,process_id,tool_id,x2.quantity,t_sap_item_code sap_item_code,sap_item_code w_sap_item_code\n" +
            "                     from pro_workorder x1\n" +
            "                     inner  join (select t2.workorder_id,t1.workorder_process_tool_id,t1.workorder_process_id,t1.tool_id,t1.sap_item_code t_sap_item_code,t1.quantity,t3.process_code,t2.process_id\n" +
            "                                            from pro_work_order_process_tool t1\n" +
            "                                                     inner join pro_work_order_process t2\n" +
            "                                                                on t1.workorder_process_id = t2.workorder_process_id\n" +
            "                                            inner join pro_process t3\n" +
            "                                                                on t3.process_id = t2.process_id) x2 on x1.workorder_id = x2.workorder_id\n" +
            "                       and arrange_code is not null\n" +
            "                       and arrange_code != '') t3 on t1.arrange_code = t3.arrange_code and  t1.process_id = t3.process_id where ptw.task_workunit_id = #{taskWorkunitId}")
    List<ProWorkOrderProcessTool> selectRequiredToolByTaskWorkunitId(@Param("taskWorkunitId") Long taskWorkunitId);

}
