package com.ximai.mes.pro.mapper.proWorkOrder;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessQcindex;

/**
 * 工单工序工装Mapper接口
 *
 * @author zht
 * @date 2024-01-28
 */
public interface ProWorkOrderProcessQcindexMapper extends BaseMapper<ProWorkOrderProcessQcindex>
{
    /**
     * 查询工单工序工装
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 工单工序工装
     */
    public ProWorkOrderProcessQcindex selectProWorkOrderProcessQcindexById(Long workorderProcessQcindex);

    /**
     * 查询工单工序工装列表
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 工单工序工装集合
     */
    public List<ProWorkOrderProcessQcindex> selectProWorkOrderProcessQcindexList(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 新增工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    public int insertProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 修改工单工序工装
     *
     * @param proWorkOrderProcessQcindex 工单工序工装
     * @return 结果
     */
    public int updateProWorkOrderProcessQcindex(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex);

    /**
     * 删除工单工序工装
     *
     * @param workorderProcessQcindex 工单工序工装主键
     * @return 结果
     */
    public int deleteProWorkOrderProcessQcindexById(Long workorderProcessQcindex);

    /**
     * 批量删除工单工序工装
     *
     * @param workorderProcessQcindexs 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProWorkOrderProcessQcindexByIds(Long[] workorderProcessQcindexs);

    List<ProWorkOrderProcessQcindex> selectProWorkOrderProcessQcindexByWorkorderProcessId(Long workorderProcessId);
}
