package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProStartWork;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 开始作业记录表Mapper接口
 *
 * @author generator
 * @date 2024-03-11
 */
public interface ProStartWorkMapper extends BaseMapper<ProStartWork> {
    /**
     * 查询开始作业记录表
     *
     * @param startWorkId 开始作业记录表主键
     * @return 开始作业记录表
     */
    ProStartWork selectProStartWorkByStartWorkId(Long startWorkId);

    /**
     * 查询开始作业记录表列表
     *
     * @param proStartWork 开始作业记录表
     * @return 开始作业记录表集合
     */
    List<ProStartWork> selectProStartWorkList(ProStartWork proStartWork);

    /**
     * 新增开始作业记录表
     *
     * @param proStartWork 开始作业记录表
     * @return 结果
     */
    int insertProStartWork(ProStartWork proStartWork);

    /**
     * 修改开始作业记录表
     *
     * @param proStartWork 开始作业记录表
     * @return 结果
     */
    int updateProStartWork(ProStartWork proStartWork);

    /**
     * 删除开始作业记录表
     *
     * @param startWorkId 开始作业记录表主键
     * @return 结果
     */
    int deleteProStartWorkByStartWorkId(Long startWorkId);

    /**
     * 批量删除开始作业记录表
     *
     * @param startWorkIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProStartWorkByStartWorkIds(Long[] startWorkIds);


    @Select("select * from pro_start_work ${ew.customSqlSegment}")
    List<ProStartWork> selectListByQw(@Param("ew") QueryWrapper<ProStartWork> query);
}
