package com.ximai.mes.pro.mapper;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRule;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 排产换型对照信息Mapper接口
 *
 * @author generator
 * @date 2024-04-01
 */
public interface ProScheduleSetupRuleMapper extends BaseMapper<ProScheduleSetupRule>
{
    /**
     * 查询排产换型对照信息
     *
     * @param ruleId 排产换型对照信息主键
     * @return 排产换型对照信息
     */
    public ProScheduleSetupRule selectProScheduleSetupRuleByRuleId(Long ruleId);

    /**
     * 查询排产换型对照信息列表
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 排产换型对照信息集合
     */
    public List<ProScheduleSetupRule> selectProScheduleSetupRuleList(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 新增排产换型对照信息
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    public int insertProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 修改排产换型对照信息
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    public int updateProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule);

    /**
     * 删除排产换型对照信息
     *
     * @param ruleId 排产换型对照信息主键
     * @return 结果
     */
    public int deleteProScheduleSetupRuleByRuleId(Long ruleId);

    /**
     * 批量删除排产换型对照信息
     *
     * @param ruleIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProScheduleSetupRuleByRuleIds(Long[] ruleIds);

    /**
     * 查询编排单对照表列表
     *
     * @param query 编排单对照表
     * @return 编排单对照表集合
     */
    @Select(value = "select item_type_name,process_name,tool,mould,plate,material_recoil,sheet_length,sheet_width,product_standard,pro_con_color,inlay,route_code,product_width" +
            " from pro_schedule_setup_rule ${ew.customSqlSegment}")
    List<Map<String, Object>> selectProScheduleSetupRuleWithMap(@Param("ew") QueryWrapper<ProScheduleSetupRule> query);
}
