package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProCombination;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产组合单Mapper接口
 *
 * @author generator
 * @date 2024-02-28
 */
public interface ProCombinationMapper extends BaseMapper<ProCombination> {
    /**
     * 查询生产组合单
     *
     * @param combinationId 生产组合单主键
     * @return 生产组合单
     */
    ProCombination selectProCombinationByCombinationId(Long combinationId);

    /**
     * 查询生产组合单列表
     *
     * @param proCombination 生产组合单
     * @return 生产组合单集合
     */
    List<ProCombination> selectProCombinationList(ProCombination proCombination);

    /**
     * 查询是否满足创建组合单
     *
     * @param workorderIds 生产单
     * @return 受影响行数
     */
    List<String> selectProCombinationInWorkorderGroup(Long[] workorderIds);

    /**
     * mark
     * 查询生产组合单列表
     *
     * @param proCombination 生产组合单
     * @return 生产组合单集合
     */
    List<ProCombination> selectProCombList(ProCombination proCombination);


    /**
     * 新增生产组合单
     *
     * @param proCombination 生产组合单
     * @return 结果
     */
    int insertProCombination(ProCombination proCombination);

    /**
     * 修改生产组合单
     *
     * @param proCombination 生产组合单
     * @return 结果
     */
    int updateProCombination(ProCombination proCombination);

    /**
     * 删除生产组合单
     *
     * @param combinationId 生产组合单主键
     * @return 结果
     */
    int deleteProCombinationByCombinationId(Long combinationId);

    /**
     * 批量删除生产组合单
     *
     * @param combinationIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProCombinationByCombinationIds(Long[] combinationIds);


    @Select(value = "select * from pro_combination  ${ew.customSqlSegment}")
    List<ProCombination> selectListByQw(@Param("ew") QueryWrapper<ProCombination> qw2);


    /**
     * 根据工单批量删除生产编排单
     *
     * @param queryWrapper 需要删除的数据主键集合
     * @return 结果
     */
    @Delete(value = "delete from pro_combination  ${ew.customSqlSegment}")
    void deleteProCombination(@Param("ew") QueryWrapper<ProCombination> queryWrapper);

}
