package com.ximai.mes.pro.domain.vo.task;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 外协拆分参数
 *
 * @author chicheng.li
 * @date 2024-09-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskWorkunitOutsourceSplitParam {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("派工任务ID")
    private Long taskWorkunitId;

    @ApiModelProperty("拆分数量")
    private BigDecimal splitQuantity;

    @ApiModelProperty("外委单价")
    private BigDecimal outsourceUnitPrice;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    @ApiModelProperty("供应商ID")
    private Long vendorId;

    @ApiModelProperty("供应商名称")
    private String vendorName;

}
