package com.ximai.mes.pro.domain.vo.task;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 包装工序报工列表
 *
 * @date 2024-05-13
 */
@Data
public class FeedbackPackageInfo {

    @ApiModelProperty("SIZE动态字段列名")
    private String sizeColumnName;

    @ApiModelProperty("指令报工数据")
    private List<FeedbackPackageDetail> directiveList;

    @ApiModelProperty("SIZE报工数据")
    private List<FeedbackPackageDetail> sizeList;

    @ApiModelProperty("工单包装标签报工数据")
    private List<FeedbackPackageDetail> orderPackageList;

    @Data
    public static class FeedbackPackageDetail {

        /** 派工单ID */
        @ApiModelProperty("派工单ID")
        private Long taskWorkunitId;

        /** 工单ID */
        @ApiModelProperty("工单ID")
        private Long workorderId;

        /** 工单指令ID */
        @ApiModelProperty("工单指令ID")
        private Long workorderSoDirectiveId;

        /** 工单SIZE */
        @ApiModelProperty("工单SIZE")
        private Long workorderSoSizeItemId;

        /** 报工单ID */
        @ApiModelProperty("报工单ID")
        private Long feedbackId;

        /** 当前面码 */
        @ApiModelProperty("当前面码")
        private Integer sheetCount;

        @ApiModelProperty("二维码")
        private String qrcode;

        @ApiModelProperty("总页码")
        private Integer totalCount;

        @ApiModelProperty("包装数")
        private Integer packageNum=0;

        @ApiModelProperty("LOSS数")
        private Integer lossNum=0;

        @ApiModelProperty("净重")
        private BigDecimal netWeight;

        @ApiModelProperty("录入人员")
        private String inputBy;

        @ApiModelProperty("检验人员")
        private String checkBy;

        @ApiModelProperty("打印次数")
        private Integer printTime;

        @ApiModelProperty("bl分组号")
        private Integer blGroup;

        private Integer index;

        @ApiModelProperty("派工数")
        private BigDecimal quantity;
        @ApiModelProperty("毛重")
        private BigDecimal grossWeight;
        @ApiModelProperty("装箱规格")
        private String packageStandard;
        @ApiModelProperty("已包装数量")
        private BigDecimal feedbackQuantity=BigDecimal.ZERO;
        @ApiModelProperty("标准SIZE")
        private String standardSize;
        @ApiModelProperty("标准SIZE序号")
        private String standardSizeIdx;
        @ApiModelProperty("指令号")
        private String clientCmd;
        @ApiModelProperty("是否装箱")
        private int isEncase=0;

        @ApiModelProperty("箱包装/LOSS单独包装数量分布")
        List<QuantityDistribute> distributes;

    }
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class QuantityDistribute{

        @ApiModelProperty("SIZE_ID")
        private Long sizeId;

        @ApiModelProperty("派工数")
        private BigDecimal quantity;

        @ApiModelProperty("标准SIZE")
        private String standardSize;

        @ApiModelProperty("包装数")
        private Integer packageNum;

        @ApiModelProperty("LOSS数")
        private Integer lossNum=0;
    }
}
