package com.ximai.mes.pro.domain.vo.proWorkOrder;

import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProPackagePrintRecord;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


import java.math.BigDecimal;
import java.util.Date;

/**
 * 包装标签打印内容数据
 *
 * @date 2024-03-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WorkorderPackagePrint {

    @ApiModelProperty("当前页码")
    String currentSheet;
    @ApiModelProperty("总页码")
    String totalSheet;
    @ApiModelProperty("包装数量")
    String packageNum;
    @ApiModelProperty("实际报工包装数量")
    String reportNum;
    @ApiModelProperty("LOSS数量")
    String lossNum;

    @ApiModelProperty("条码")
    String barcode;

    @ApiModelProperty("二维码")
    String qrcode;

    @ApiModelProperty("打印人员")
    String printerBy;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("检验员")
    private String checkBy;

    //指令信息
    @ApiModelProperty("尺码组")
    String sizeGroup;
    @ApiModelProperty("指令号")
    String clientCmd;
    @ApiModelProperty("所有指令号")
    String clientCmdArray;

    //标准SIZE
    @ApiModelProperty("标准SIZE号")
    String standardSize;


    //工单
    @ApiModelProperty("品号")
    String productCode;
    @ApiModelProperty("品名")
    String productName;
    @ApiModelProperty("产品品类")
    String productType;
    @ApiModelProperty("客户名称")
    String clientName;
    @ApiModelProperty("客户代码")
    String clientCode;
    @ApiModelProperty("工单号")
    String workorderCode;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("报工时间")
    private Date feedbackTime;

    @ApiModelProperty("布袋")
    String sack;


    public void setValues(ProPackagePrintRecord record, ProWorkorder proWorkorder, MdItem item){
        this.setWorkorderCode(proWorkorder.getWorkorderCode());
        this.setProductName(proWorkorder.getProductName());
        this.setProductCode(item.getSapItemCode());
        this.setSack(item.getItemTypeName());
        this.setClientName(proWorkorder.getClientName());
        this.setClientCode(proWorkorder.getClientCode());
        this.setProductType(item.getItemTypeName());
        this.setCheckBy(record.getCheckBy());
        this.setTotalSheet(record.getTotalCount()+"");
        this.setPrinterBy(record.getCreateBy());
        this.setNetWeight(record.getNetWeight());
        this.setCurrentSheet(record.getSheetCount()+"");
        this.setBarcode(record.getBarcode());
        this.setQrcode(record.getQrcode());
    }

}
