package com.ximai.mes.pro.domain.vo.proWorkOrder;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 装箱条码打印参数
 *
 * @author lcc
 * @date 2024-02-29
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BuildPackageParams2 {

    @ApiModelProperty("工单ID")
    private Long workorderId;

    @ApiModelProperty("sap物料号")
    private String sapItemCode;

    @ApiModelProperty("工单编码")
    private String workorderCode;

    @ApiModelProperty("工单数量")
    private Integer quantity;

    @ApiModelProperty("包装数量")
    private Integer packNum;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    @ApiModelProperty("起始页码")
    private Integer currentSheet;

    @ApiModelProperty("张数")
    private Integer sheetCount;

    @ApiModelProperty
    private Integer printTime=0;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("合并包装")
    private Boolean mergePack=false;

    /**
     * 包装数量、装箱数量、是否合并包装为NULL，都默认为0
     */
    public void initPackageValue(){
        if(this.getMergePack()==null){
            setMergePack(false);
        }
        if(this.getPackNum()==null){
            setPackNum(0);
        }
        if(this.getEncasementNum()==null){
            setEncasementNum(0);
        }
        if(this.getPackNum()==0&&this.getEncasementNum()!=0){
            setPackNum(this.getEncasementNum());
        }
    }

}
