package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.task.ProTask;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 生产工单对象 pro_workorder
 *
 * @date 2022-05-15
 */
@Data
public class ProWorkorderQuery extends BaseEntity {

    /**
     * 工单ID
     */
    private Long workorderId;

    private Long processId;
    /**
     * 工艺路线ID
     */
    private Long routeId;

    private String routeCode;

    /**
     * 工艺路线
     */
    private String routeName;

    /**
     * 工单编码
     */
    @ApiModelProperty("工单编码")
    private String workorderCode;

    /**
     * 工单名称
     */
    @ApiModelProperty("工单名称")
    private String workorderName;

    /**
     * 工单类型
     */
    @ApiModelProperty("工单类型")
    private String workorderType;

    /**
     * 来源类型
     */
    @ApiModelProperty("来源类型")
    private String orderSource;

    /**
     * 来源单据
     */
    @ApiModelProperty("来源单据")
    private String sourceCode;

    /**
     * 产品ID
     */
    @ApiModelProperty("产品ID")
    private Long productId;

    /**
     * 产品编号
     */
    @ApiModelProperty("产品编号")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String productSpc;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unitOfMeasure;

    /**
     * 编排单号
     */
    @ApiModelProperty("编排单号")
    private String arrangeCode;

    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String batchCode;

    /**
     * 生产数量
     */
    @ApiModelProperty("生产数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    /**
     * 调整数量
     */
    @ApiModelProperty("调整数量")
    private BigDecimal quantityChanged;

    /**
     * 已排产数量
     */
    @ApiModelProperty("已排产数量")
    private BigDecimal quantityScheduled;

    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long clientId;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String clientName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long vendorId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String vendorCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String vendorName;

    @TableField(exist = false)
    private String itemTypeName;

    /**
     * 需求日期
     */
    @ApiModelProperty("需求日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    @ApiModelProperty("需求日期开始")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date requestDateFrom;

    @ApiModelProperty("需求日期截止")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date requestDateTo;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishDate;

    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    private String status;
    @TableField(exist = false)
    private String statusArr[];

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    private Long taskWorkunitId;

    private String parentId;
    @ApiModelProperty("订单单号")
    private String orderCode;
    @ApiModelProperty("订单序号")
    private String orderSerial;
    @ApiModelProperty("项目号")
    private String customerProjectNo;
    @ApiModelProperty("产品图号")
    @TableField(exist = false)
    private String customerDrawingNo;
    @TableField(exist = false)
    private List<Long> workorderIds;

    @TableField(exist = false)
    private List<String> workorderCodes;
}
