package com.ximai.mes.pro.domain.vo;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkOrderSoSizeItemStandard;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 包装标签打印内容数据
 *
 * @date 2024-03-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProPackagePrintResult
{

    @ApiModelProperty("工单信息")
    ProWorkorder proWorkorder;

    @ApiModelProperty("指令信息")
    ProWorkOrderSoDirective directive;

    @ApiModelProperty("SIZE信息")
    WorkOrderSoSizeItemStandard size;

    @ApiModelProperty("包装标签打印列表")
    List<PackagePrintInfo> packagePrintList=new ArrayList<PackagePrintInfo>();

    @Data
    public static class PackagePrintInfo{

        @ApiModelProperty("当前页码")
        String currentSheet;
        @ApiModelProperty("总页码")
        String totalSheet;
        @ApiModelProperty("包装数量")
        String packageNum;

        @ApiModelProperty("条码码")
        String barcode;

        @ApiModelProperty("二维码")
        String qrcode;

        @ApiModelProperty("打印人员")
        String printerBy;

        @ApiModelProperty("净重")
        private BigDecimal netWeight;

        @ApiModelProperty("检验员")
        private String checkBy;

        @ApiModelProperty("小包当前页码")
        String minCurrentSheet;
        @ApiModelProperty("小包总页码")
        String minTotalSheet;
        @ApiModelProperty("小包装数量")
        String minPackageNum;


        //指令信息

        @ApiModelProperty("尺码组")
        String sizeGroup;
        @ApiModelProperty("指令号")
        String clientCmd;
        @ApiModelProperty("所有指令号")
        String clientCmdArray;

        //标准SIZE
        @ApiModelProperty("标准SIZE号")
        String standardSize;


        //工单
        @ApiModelProperty("品号")
        String productCode;
        @ApiModelProperty("品名")
        String productName;
        @ApiModelProperty("产品品类")
        String productType;
        @ApiModelProperty("客户名称")
        String clientName;
        @ApiModelProperty("客户代码")
        String clientCode;
        @ApiModelProperty("工单号")
        String workorderCode;

    }
}
