package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * title: 生产相关SAP返回数据
 * author:ZHT
 * date:2024/2/22
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties
public class ProReturnTo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 消息类型
     */
    @JSONField(name = "TYPE")
    private String messageType;

    /**
     * 消息类
     */
    @JSONField(name = "ID")
    private String messageId;

    /**
     * 消息编号
     */
    @JSONField(name = "NUMBER")
    private String messageCode;

    /**
     * 消息文本
     */
    @JSONField(name = "MESSAGE")
    private String messageText;

    /**
     * 应用程序日志：日志编号
     */
    @JSONField(name = "LOG_NO")
    private String messageLogCode;

    /**
     * 应用程序日志：内部消息序列号
     */
    @JSONField(name = "LOG_MSG_NO")
    private String messageLogMsgCode;

    /**
     * 消息变量
     */
    @JSONField(name = "MESSAGE_V1")
    private String messageV1;

    /**
     * 消息变量
     */
    @JSONField(name = "MESSAGE_V2")
    private String messageV2;

    /**
     * 消息变量
     */
    @JSONField(name = "MESSAGE_V3")
    private String messageV3;

    /**
     * 消息变量
     */
    @JSONField(name = "MESSAGE_V4")
    private String messageV4;

    /**
     * 参数名称
     */
    @JSONField(name = "PARAMETER")
    private String messageParameterName;

    /**
     * 参数中的行
     */
    @JSONField(name = "ROW")
    private int messageRow;

    /**
     * 参数中的字段
     */
    @JSONField(name = "FIELD")
    private String messageField;

    /**
     * 引发消息的逻辑系统
     */
    @JSONField(name = "SYSTEM")
    private String messageSystem;

}
