package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * title: 生产版本传SAP工艺路线TO
 * author:ZHT
 * date:2024/2/22
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties
public class ProProductionSolutionRoteTo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * SAP物料编码
     */
    @JSONField(name = "MATNR", ordinal = 0)
    private String sapItemCode;

    /**
     * 工厂编码
     */
    @JSONField(name = "WERKS", ordinal = 1)
    private String factoryCode;

    /**
     * 组计数器
     */
    @JSONField(name = "PLNAL", ordinal = 2)
    private String groupCounter;

    /**
     * 变更编号
     */
    @JSONField(name = "AENNR", ordinal = 3)
    private String ecnCode;

    /**
     * 生产用途
     */
    @JSONField(name = "VERWE", ordinal = 4)
    private String usageCode;

    /**
     * 状态
     */
    @JSONField(name = "STATU", ordinal = 5)
    private String status;

    /**
     * 有效起始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(name = "DATUV", ordinal = 5)
    private Date startDate;

    /**
     * 工艺路线名称
     */
    @JSONField(name = "KTEXT", ordinal = 6)
    private String routeName;

    /**
     * 最小批量
     */
    @JSONField(name = "LOSVN", ordinal = 7)
    private String maxLot;

    /**
     * 最大批量
     */
    @JSONField(name = "LOSBS", ordinal = 8)
    private String minLot;

    /**
     * 单位
     */
    @JSONField(name = "PLNME", ordinal = 9)
    private String unitOfMeasure;

    /**
     * 更新标识
     */
    @JSONField(name = "UPDKZ", ordinal = 10)
    private String updateLogo;

    /**
     * 工序列表
     */
    @JSONField(name = "ITEM", ordinal = 11)
    private List<ProProductionSolutionProcessTo> processList;

}
