package com.ximai.mes.pro.domain.productionSolution;

import java.math.BigDecimal;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 生产版本BOM对象 pro_production_solution_bom
 *
 * @author zht
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionBom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long bomItemId;

    /** 生产版本ID */
    @Excel(name = "生产版本ID")
    private Long productionSolutionId;

    /** 产品id */
    @Excel(name = "产品id")
    private Long itemId;

    private String itemName;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Long alternativePriorities;

    /** 替代策略 */
    @Excel(name = "替代策略")
    private String alternativeStrategy;

    /** 替代使用概率 */
    @Excel(name = "替代使用概率")
    private BigDecimal alternativeProbability;

    /** BOM行备注 */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String itemRemark;
}
