package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 排产换型对照信息对象 pro_schedule_setup_rule
 *
 * @author generator
 * @date 2024-04-01
 */
@Data
public class ProScheduleSetupRule extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @TableId
    private Long ruleId;

    /** 换型关键字 */
    @ApiModelProperty("换型关键字")
    private String ruleCode;

    /** 产品类别ID */
    @ApiModelProperty("产品类别ID")
    private Long itemTypeId;

    /** 产品类别名称 */
    @ApiModelProperty("产品类别名称")
    private String itemTypeName;

    /** 工序ID */
    @ApiModelProperty("工序ID")
    private Long processId;

    /** 工序名称 */
    @ApiModelProperty("工序名称")
    private String processName;

    /** 刀 */
    @ApiModelProperty("刀")
    private Integer tool;

    /** 模 */
    @ApiModelProperty("模")
    private Integer mould;

    /** 版 */
    @ApiModelProperty("版")
    private Integer plate;

    /** 材料（反冲） */
    @ApiModelProperty("材料(反冲)")
    private Integer materialRecoil;

    /** 印张长度 */
    @ApiModelProperty("印张长度")
    private Integer sheetLength;

    /** 印张宽度 */
    @ApiModelProperty("印张宽度")
    private Integer sheetWidth;

    /** 产品规格 */
    @ApiModelProperty("产品规格")
    private Integer productStandard;

    /** 正反颜色 */
    @ApiModelProperty("正反颜色")
    private Integer proConColor;

    /**  */
    @ApiModelProperty("Inlay")
    private Integer inlay;

    /** 工艺路线 */
    @ApiModelProperty("工艺路线")
    private Integer routeCode;

    /** 产品材质宽度 */
    @ApiModelProperty("产品材质宽度")
    private Integer productWidth;


}
