package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.vo.ProWorkorderMateVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 生产组合单对象 pro_combination
 *
 * @author generator
 * @date 2024-02-28
 */
@Data
public class ProCombination extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long combinationId;

    /**
     * 组合单号
     */
    @Excel(name = "组合单号")
    private String combinationCode;

    /**
     * 序号
     */
    @Excel(name = "序号")
    private Long combinationSort;

    /**
     * 生产工单号
     */
    @Excel(name = "生产工单号")
    private Long workorderId;

    /**
     * 生产工单编号
     */
    @Excel(name = "生产工单编号")
    private String workorderCode;

    /**
     * 销售订单号
     */
    @Excel(name = "销售订单号")
    private Long salesOrderId;

    /** 要匹配的字符 */
    @TableField(exist = false)
    private ProWorkorderMateVo matching;

    /** 印张数*/
    @TableField(exist = false)
    private BigDecimal frame;

    /**记录数*/
    @TableField(exist = false)
    private Integer x;


    /**
     * 需求日期
     */
    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date requestDate;

}
