package com.ximai.mes.pro.controller.prototypeMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeBom;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeBomService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 样品制作BOMController
 *
 * @author zht
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mes/pro/prototypeMakeBom")
public class ProPrototypeMakeBomController extends BaseController
{
    @Autowired
    private IProPrototypeMakeBomService proPrototypeMakeBomService;

    /**
     * 查询样品制作BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeMakeBom proPrototypeMakeBom)
    {
        startPage();
        List<ProPrototypeMakeBom> list = proPrototypeMakeBomService.selectProPrototypeMakeBomList(proPrototypeMakeBom);
        return getDataTable(list);
    }


    /**
     * 获取样品制作BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proPrototypeMakeBomService.selectProPrototypeMakeBomByBomItemId(bomItemId));
    }

    /**
     * 新增样品制作BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeBom:add')")
    @Log(title = "样品制作BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeMakeBom proPrototypeMakeBom)
    {
        return toAjax(proPrototypeMakeBomService.insertProPrototypeMakeBom(proPrototypeMakeBom));
    }

    /**
     * 修改样品制作BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeBom:edit')")
    @Log(title = "样品制作BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeMakeBom proPrototypeMakeBom)
    {
        return toAjax(proPrototypeMakeBomService.updateProPrototypeMakeBom(proPrototypeMakeBom));
    }

    /**
     * 删除样品制作BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeBom:remove')")
    @Log(title = "样品制作BOM", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proPrototypeMakeBomService.deleteProPrototypeMakeBomByBomItemIds(bomItemIds));
    }
}
