package com.ximai.mes.pro.controller.productionRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.ProProductionRequestEditVo;
import com.ximai.mes.pro.domain.vo.ProProductionRequestVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequest;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产申请Controller
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/mes/pro/productionRequest")
public class ProProductionRequestController extends BaseController
{
    @Autowired
    private IProProductionRequestService proProductionRequestService;

    /**
     * 查询量产申请列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionRequest proProductionRequest)
    {
        startPage();
        List<ProProductionRequest> list = proProductionRequestService.selectProProductionRequestListJoin(proProductionRequest);
        return getDataTable(list);
    }

    /**
     * 获取量产申请详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:query')")
    @GetMapping(value = "/{productionRequestId}")
    public AjaxResult getInfo(@PathVariable("productionRequestId") Long productionRequestId)
    {
        return AjaxResult.success(proProductionRequestService.selectProProductionRequestByProductionRequestId(productionRequestId));
    }

    /**
     * 新增量产申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:add')")
    @Log(title = "量产申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionRequestVo proProductionRequest)
    {
        return toAjax(proProductionRequestService.insertProProductionRequest(proProductionRequest));
    }

    /**
     * 修改量产申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:edit')")
    @Log(title = "量产申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionRequestEditVo proProductionRequestEditVo)
    {
        return toAjax(proProductionRequestService.updateProProductionRequest(proProductionRequestEditVo));
    }

    /**
     * 删除量产申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:remove')")
    @Log(title = "量产申请", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionRequestIds}")
    public AjaxResult remove(@PathVariable Long[] productionRequestIds)
    {
        return toAjax(proProductionRequestService.deleteProProductionRequestByProductionRequestIds(productionRequestIds));
    }

    /** 状态修改 */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequest:edit')")
    @Log(title = "状态修改", businessType = BusinessType.UPDATE)
    @PutMapping("/modifyState")
    public AjaxResult editStatus(@RequestBody ProProductionRequest proProductionRequest)
    {
        return toAjax(proProductionRequestService.updateProProductionRequestStatus(proProductionRequest));
    }
}
