package com.ximai.mes.pro.controller.productionMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeBom;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeBomService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产制作BOMController
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionMakeBom")
public class ProProductionMakeBomController extends BaseController
{
    @Autowired
    private IProProductionMakeBomService proProductionMakeBomService;

    /**
     * 查询量产制作BOM列表
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionMakeBom proProductionMakeBom)
    {
        startPage();
        List<ProProductionMakeBom> list = proProductionMakeBomService.selectProProductionMakeBomList(proProductionMakeBom);
        return getDataTable(list);
    }

    /**
     * 获取量产制作BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proProductionMakeBomService.selectProProductionMakeBomByBomItemId(bomItemId));
    }

    /**
     * 新增量产制作BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeBom:add')")
    @Log(title = "量产制作BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionMakeBom proProductionMakeBom)
    {
        return toAjax(proProductionMakeBomService.insertProProductionMakeBom(proProductionMakeBom));
    }

    /**
     * 修改量产制作BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeBom:edit')")
    @Log(title = "量产制作BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionMakeBom proProductionMakeBom)
    {
        return toAjax(proProductionMakeBomService.updateProProductionMakeBom(proProductionMakeBom));
    }

    /**
     * 删除量产制作BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeBom:remove')")
    @Log(title = "量产制作BOM", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proProductionMakeBomService.deleteProProductionMakeBomByBomItemIds(bomItemIds));
    }
}
