package com.ximai.mes.pro.controller.proWorkOrder;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderArrangeRuleValService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderArrangeRuleVal;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 工单编排规则属性唯一值Controller
 *
 * @author generator
 * @date 2024-03-26
 */
@RestController
@RequestMapping("/proWorkOrder/proWorkOrder")
public class ProWorkOrderArrangeRuleValController extends BaseController
{
    @Autowired
    private IProWorkOrderArrangeRuleValService proWorkOrderArrangeRuleValService;

    /**
     * 查询工单编排规则属性唯一值列表
     */
    @PreAuthorize("@ss.hasPermi('proWorkOrder:proWorkOrder:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal)
    {
        startPage();
        List<ProWorkOrderArrangeRuleVal> list = proWorkOrderArrangeRuleValService.selectProWorkOrderArrangeRuleValList(proWorkOrderArrangeRuleVal);
        return getDataTable(list);
    }


    /**
     * 获取工单编排规则属性唯一值详细信息
     */
    @PreAuthorize("@ss.hasPermi('proWorkOrder:proWorkOrder:query')")
    @GetMapping(value = "/{arrangeRuleId}")
    public AjaxResult getInfo(@PathVariable("arrangeRuleId") Long arrangeRuleId)
    {
        return AjaxResult.success(proWorkOrderArrangeRuleValService.selectProWorkOrderArrangeRuleValByArrangeRuleId(arrangeRuleId));
    }

    /**
     * 新增工单编排规则属性唯一值
     */
    @PreAuthorize("@ss.hasPermi('proWorkOrder:proWorkOrder:add')")
    @Log(title = "工单编排规则属性唯一值", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal)
    {
        return toAjax(proWorkOrderArrangeRuleValService.insertProWorkOrderArrangeRuleVal(proWorkOrderArrangeRuleVal));
    }

    /**
     * 修改工单编排规则属性唯一值
     */
    @PreAuthorize("@ss.hasPermi('proWorkOrder:proWorkOrder:edit')")
    @Log(title = "工单编排规则属性唯一值", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal)
    {
        return toAjax(proWorkOrderArrangeRuleValService.updateProWorkOrderArrangeRuleVal(proWorkOrderArrangeRuleVal));
    }

    /**
     * 删除工单编排规则属性唯一值
     */
    @PreAuthorize("@ss.hasPermi('proWorkOrder:proWorkOrder:remove')")
    @Log(title = "工单编排规则属性唯一值", businessType = BusinessType.DELETE)
	@DeleteMapping("/{arrangeRuleIds}")
    public AjaxResult remove(@PathVariable Long[] arrangeRuleIds)
    {
        return toAjax(proWorkOrderArrangeRuleValService.deleteProWorkOrderArrangeRuleValByArrangeRuleIds(arrangeRuleIds));
    }
}
