package com.ximai.mes.pro.controller.mobile;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProMaterialUsageRecord;
import com.ximai.mes.pro.service.IProMaterialUsageRecordService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产物料扣减Controller
 *
 * @author mengcheng
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mobile/pro/materialusagerecord")
public class ProMaterialUsageRecordController extends BaseController
{
    @Autowired
    private IProMaterialUsageRecordService proMaterialUsageRecordService;

    /**
     * 查询生产物料扣减列表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProMaterialUsageRecord:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProMaterialUsageRecord proMaterialUsageRecord)
    {
        startPage();
        List<ProMaterialUsageRecord> list = proMaterialUsageRecordService.selectProMaterialUsageRecordList(proMaterialUsageRecord);
        return getDataTable(list);
    }

    /**
     * 获取生产物料扣减详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:ProMaterialUsageRecord:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(proMaterialUsageRecordService.selectProMaterialUsageRecordByRecordId(recordId));
    }

    /**
     * 新增生产物料扣减
     */
    @PreAuthorize("@ss.hasPermi('pro:ProMaterialUsageRecord:add')")
    @Log(title = "生产物料扣减", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(ProMaterialUsageRecord proMaterialUsageRecord)
    {
        return toAjax(proMaterialUsageRecordService.insertProMaterialUsageRecord(proMaterialUsageRecord));
    }

    /**
     * 修改生产物料扣减
     */
    @PreAuthorize("@ss.hasPermi('pro:ProMaterialUsageRecord:edit')")
    @Log(title = "生产物料扣减", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProMaterialUsageRecord proMaterialUsageRecord)
    {
        return toAjax(proMaterialUsageRecordService.updateProMaterialUsageRecord(proMaterialUsageRecord));
    }

    /**
     * 删除生产物料扣减
     */
    @PreAuthorize("@ss.hasPermi('pro:ProMaterialUsageRecord:remove')")
    @Log(title = "生产物料扣减", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(proMaterialUsageRecordService.deleteProMaterialUsageRecordByRecordIds(recordIds));
    }
}
