package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.ProBom;
import com.ximai.mes.pro.service.IProBomService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * BOMController
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/mes/pro/bom")
public class ProBomController extends BaseController {

    @Autowired
    private IProBomService proBomService;

    /**
     * 查询BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProBom proBom) {
        startPage();
        List<ProBom> list = proBomService.selectProBomList(proBom);
        return getDataTable(list);
    }

    /**
     * 获取BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:query')")
    @GetMapping(value = "/{bomId}")
    public AjaxResult getInfo(@PathVariable("bomId") Long bomId) {
        return AjaxResult.success(proBomService.selectProBomByBomId(bomId));
    }

    /**
     * 新增BOM
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:add')")
    @Log(title = "BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProBom proBom) {
        return toAjax(proBomService.insertProBom(proBom));
    }

    /**
     * 修改BOM
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:edit')")
    @Log(title = "BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProBom proBom) {
        return toAjax(proBomService.updateProBom(proBom));
    }

    /**
     * 删除BOM
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:bom:remove')")
    @Log(title = "BOM", businessType = BusinessType.DELETE)
    @DeleteMapping("/{bomIds}")
    public AjaxResult remove(@PathVariable Long[] bomIds) {
        return toAjax(proBomService.deleteProBomByBomIds(bomIds));
    }
}
