package com.ximai.mes.od.vo.sap;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.ximai.mes.od.domain.OdSalesOrderDetail;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

/**
 * @since created by hyy on 2024-01-26
 */
@Data
public class SapSaleOrderDetail {

    /**
     * 销售凭证项目
     */
    private String POSNR;
    /**
     * 物料编号
     */
    private String MATNR;
    /**
     * 工厂
     */
    private String WERKS;
    /**
     * 以销售单位表示的累计订购数量 不传
     */
    private Integer KWMENG;
    /**
     * 客户物料编号
     */
    private String KDMAT;
    /**
     * 客户物料名称
     */
    private String ARKTX;
    /**
     * LOSS数(客户)汇总
     */
    private Integer ZLOSSUM;
    /**
     * 折扣率（Z001的金额）
     */
    private String NETPR;
    /**
     * 装运点/收货点
     */
    private String VSTEL;
    /**
     * 存储地点
     */
    private String LGORT;
    /**
     * 批次编号
     */
    private String CHARG;
    /**
     * 计划行日期
     */
    private String EDATU;
    /**
     * 工厂单价（PR01的金额）
     */
    private BigDecimal NETWR;
    /**
     * 订单行折前总金额（Z002的定价值）
     */
    private String KWERT;
    /**
     * 定价单位
     */
    private String KPEIN;
    /**
     * 货币
     */
    private String KOEIN;
    /**
     * 拒绝原因
     */
    private String ABGRU;
    /**
     * 尺码组
     */
    private String ZSIZEGROUP;
    /**
     * 尺码单位（客户）
     */
    private String ZSIZEUNITC;
    /**
     * 指令号
     */
    private String ZINSTNUM;
    /**
     * 型体号
     */
    private String ZMOLD;
    /**
     * 配色号
     */
    private String ZMAPCOLOR;
    /**
     * 颜色
     */
    private String ZCLOLOR;
    /**
     * 销线
     */
    private String ZSALEAREA;
    /**
     * 段别
     */
    private String ZDUANBIE;
    /**
     * 季度
     */
    private String ZSEASON;
    /**
     * 整/半码
     */
    private String ZTOTALSIZE;
    /**
     * 特殊SIZE
     */
    private String ZSPECSIZE;
    /**
     * PO#
     */
    private String ZCPONUM;
    /**
     * WIP#
     */
    private String ZWIPNUM;
    /**
     * 装箱数
     */
    private String ZBOXQUAN;
    /**
     * 产地
     */
    private String ZORIGIN;
    /**
     * 周期
     */
    private String ZCYCLE;
    /**
     * SK编号
     */
    private String ZSKCODE;
    /**
     * 专利号
     */
    private String ZPATENTCODE;
    /**
     * 材质描述
     */
    private String ZMATERIALDES;
    /**
     * 签收人
     */
    private String ZSIGNPERSON;
    /**
     * SHIP TO ID
     */
    private String ZSHIPID;
    /**
     * 产品规格
     */
    private String ZPRODSPEC;
    /**
     * 产品用途
     */
    private String ZPRODUSAGE;
    /**
     * 厚度（丝）
     */
    private String ZTHICK;
    /**
     * 包装方式
     */
    private String ZPACKINGMOT;
    /**
     * 印刷方向
     */
    private String ZPRINTDIRECT;
    /**
     * 工厂代号
     */
    private String ZPLANTCODE;
    /**
     * 指令数(客户)汇总
     */
    private String ZINCSUM;

    private List<SapSaleOrderDetailSize> SIZE;


    public static SapSaleOrderDetail buildSapSaleOrderDetail(OdSalesOrderDetail orderDetail) {
        final SapSaleOrderDetail sapSaleOrderDetail = new SapSaleOrderDetail();
        sapSaleOrderDetail.setPOSNR(orderDetail.getOrderNo());
        sapSaleOrderDetail.setMATNR(orderDetail.getSapItemNo());
        sapSaleOrderDetail.setWERKS(orderDetail.getSaleFactory());
        sapSaleOrderDetail.setKWMENG(orderDetail.getTotalNum());
        sapSaleOrderDetail.setKDMAT(orderDetail.getClientItemNo());
        sapSaleOrderDetail.setARKTX(orderDetail.getClientItemName());
        sapSaleOrderDetail.setZLOSSUM(orderDetail.getLossNum());
        sapSaleOrderDetail.setNETPR(null);
        sapSaleOrderDetail.setVSTEL(orderDetail.getShipmentPointNo());
        sapSaleOrderDetail.setLGORT(orderDetail.getStoreAddr());
        sapSaleOrderDetail.setCHARG(orderDetail.getBatchNo());
        sapSaleOrderDetail.setEDATU(DateUtil.format(orderDetail.getDeliveryDate(), DatePattern.PURE_DATE_PATTERN));
        sapSaleOrderDetail.setNETWR(orderDetail.getPrice());
        sapSaleOrderDetail.setKWERT(orderDetail.getPricingVal());
        sapSaleOrderDetail.setKPEIN(orderDetail.getOfferUnit());
        sapSaleOrderDetail.setKOEIN(null);
        sapSaleOrderDetail.setABGRU(null);
        sapSaleOrderDetail.setZSIZEGROUP(orderDetail.getSizeGroup());
        sapSaleOrderDetail.setZSIZEUNITC(orderDetail.getClientSizeUnit());
        sapSaleOrderDetail.setZINSTNUM(orderDetail.getClientCmd());
        sapSaleOrderDetail.setZMOLD(orderDetail.getTypeNo());
        sapSaleOrderDetail.setZMAPCOLOR(orderDetail.getColorNo());
        sapSaleOrderDetail.setZCLOLOR(orderDetail.getColor());
        sapSaleOrderDetail.setZSALEAREA(orderDetail.getSalePath());
        sapSaleOrderDetail.setZDUANBIE(orderDetail.getSegment());
        sapSaleOrderDetail.setZSEASON(orderDetail.getQuarter());
        sapSaleOrderDetail.setZTOTALSIZE(orderDetail.getWholeSize());
        sapSaleOrderDetail.setZSPECSIZE(orderDetail.getSpecSize());
        sapSaleOrderDetail.setZCPONUM(orderDetail.getPoNo());
        sapSaleOrderDetail.setZWIPNUM(orderDetail.getWipNo());
        sapSaleOrderDetail.setZBOXQUAN(orderDetail.getPackingNum());
        sapSaleOrderDetail.setZORIGIN(null);
        sapSaleOrderDetail.setZCYCLE(orderDetail.getCycle());
        sapSaleOrderDetail.setZSKCODE(orderDetail.getSkNo());
        sapSaleOrderDetail.setZPATENTCODE(orderDetail.getPatentNo());
        sapSaleOrderDetail.setZMATERIALDES(orderDetail.getMaterialDesc());
        sapSaleOrderDetail.setZSIGNPERSON(orderDetail.getSigner());
        sapSaleOrderDetail.setZSHIPID(orderDetail.getShipToId());
        sapSaleOrderDetail.setZPRODSPEC(orderDetail.getProdSpec());
        sapSaleOrderDetail.setZPRODUSAGE(null);
        sapSaleOrderDetail.setZTHICK(null);
        sapSaleOrderDetail.setZPACKINGMOT(orderDetail.getPackMode());
        sapSaleOrderDetail.setZPRINTDIRECT(orderDetail.getPrintingDirection());
        sapSaleOrderDetail.setZPLANTCODE(orderDetail.getPlantCode());
        sapSaleOrderDetail.setZINCSUM(null);
        final SapSaleOrderDetailSize size = new SapSaleOrderDetailSize();
        size.setZSIZE_NUM("1");
        size.setZSIZE(orderDetail.getSize());
        size.setZINSNUM(orderDetail.getNum());
        size.setZLOSSC(orderDetail.getLossNum());
        size.setZSIZECOM(orderDetail.getRemark());
        sapSaleOrderDetail.setSIZE(Collections.singletonList(size));

        return sapSaleOrderDetail;
    }
}
