package com.ximai.mes.od.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.od.domain.OdSalesOrderProductDetail;
import com.ximai.mes.od.mapper.OdSalesOrderProductDetailMapper;
import com.ximai.mes.od.service.IOdSalesOrderProductDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 销售订单产品详情Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class OdSalesOrderProductDetailServiceImpl implements IOdSalesOrderProductDetailService {
    @Autowired
    private OdSalesOrderProductDetailMapper odSalesOrderProductDetailMapper;

    /**
     * 查询销售订单产品详情
     *
     * @param id 销售订单产品详情主键
     * @return 销售订单产品详情
     */
    @Override
    public OdSalesOrderProductDetail selectOdSalesOrderProductDetailById(String id) {
        return odSalesOrderProductDetailMapper.selectOdSalesOrderProductDetailById(id);
    }

    /**
     * 查询销售订单产品详情列表
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 销售订单产品详情
     */
    @Override
    public List<OdSalesOrderProductDetail> selectOdSalesOrderProductDetailList(OdSalesOrderProductDetail odSalesOrderProductDetail) {
        return odSalesOrderProductDetailMapper.selectOdSalesOrderProductDetailList(odSalesOrderProductDetail);
    }

    /**
     * 新增销售订单产品详情
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 结果
     */
    @Override
    public int insertOdSalesOrderProductDetail(OdSalesOrderProductDetail odSalesOrderProductDetail) {
        odSalesOrderProductDetail.setCreateTime(DateUtils.getNowDate());
        return odSalesOrderProductDetailMapper.insertOdSalesOrderProductDetail(odSalesOrderProductDetail);
    }

    /**
     * 修改销售订单产品详情
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 结果
     */
    @Override
    public int updateOdSalesOrderProductDetail(OdSalesOrderProductDetail odSalesOrderProductDetail) {
        odSalesOrderProductDetail.setUpdateTime(DateUtils.getNowDate());
        return odSalesOrderProductDetailMapper.updateOdSalesOrderProductDetail(odSalesOrderProductDetail);
    }

    /**
     * 批量删除销售订单产品详情
     *
     * @param ids 需要删除的销售订单产品详情主键
     * @return 结果
     */
    @Override
    public int deleteOdSalesOrderProductDetailByIds(String[] ids) {
        return odSalesOrderProductDetailMapper.deleteOdSalesOrderProductDetailByIds(ids);
    }

    /**
     * 删除销售订单产品详情信息
     *
     * @param id 销售订单产品详情主键
     * @return 结果
     */
    @Override
    public int deleteOdSalesOrderProductDetailById(String id) {
        return odSalesOrderProductDetailMapper.deleteOdSalesOrderProductDetailById(id);
    }
}
